begin sierra ReusePreloadedPart
  #
  # Define materials for all parts in the final assembly
  #
  begin material gasket
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10e4
      poissons ratio = 0.33
      yield stress = 2500
      hardening modulus = 10e2
    end 
  end

  begin material steel
    density = 7.32e-4
    begin parameters for model elastic_plastic
      youngs modulus = 30e6
      poissons ratio = 0.29
      hardening modulus = 150e3
    end 
  end

  begin material foam
    density = 2.5e-4
    begin parameters for model elastic
      youngs modulus = 150
      poissons ratio = 0.35
    end 
  end

  begin material aluminum
    density = 2.5e-4
    begin parameters for model elastic
      youngs modulus = 10e6
      poissons ratio = 0.33
    end 
  end

  #
  # Finite element model #1: Preloaded can only
  #
  begin finite element model preloaded_canister
    database name = canister.g

    begin parameters for block bottom_foam top_foam
      material = foam
      model = elastic
      hourglass stiffness = 0.2
    end 

    begin parameters for block can can_lid
      material = aluminum
      model = elastic
      hourglass stiffness = 0.2
    end 
  end

  #
  # Finite element model #2: Full assembly, multiple cans
  #
  begin finite element model two_canisters
    database name = housing_with_two_canisters.g

    begin parameters for block bottom_foam top_foam bottom_foam_2 top_foam_2
      material = foam
      model = elastic
      hourglass stiffness = 0.2
    end 

    begin parameters for block can can_lid can_2 can_lid_2
      material = aluminum
      model = elastic
      hourglass stiffness = 0.2
    end 

    begin parameters for block housing_top housing_bottom
      material = steel
      model = elastic_plastic
    end 

    begin parameters for block gasket
      material = gasket
      model = elastic_plastic
    end 
  end
  
  #
  # Procedure #1: Load the preloaded part using a restart file
  #
  begin adagio procedure load_part
    begin time control
      begin time stepping block tb_load
        start time = 0.0
        begin parameters for adagio region region_load
          number of time steps = 1
        end 
      end 
      termination time = 1.0
    end time control

    begin adagio region region_load
      use finite element model preloaded_canister

      begin restart data
        input database name = preloaded_canister.rst
        restart time = 1.0
      end

      #
      # The combination of a single time step, zero velocity, and a default solver
      # allows this model to load and immediately transfer to the next procedure
      # without any "solving".
      #
      begin prescribed velocity
        include all blocks
        component = x
        function = sierra_constant_function_zero
      end
      begin prescribed velocity
        include all blocks
        component = y
        function = sierra_constant_function_zero
      end
      begin prescribed velocity
        include all blocks
        component = z
        function = sierra_constant_function_zero
      end

      begin solver
      end
    end adagio region region_load
  end adagio procedure load_part

  begin adagio procedure adagio_proc1
    # 
    # The procedural trasnfer contains two individual _INTERPOLATION_ transfers:
    #   * can -> "can #1"
    #   * can -> "can #2"
    #
    begin procedural transfer
      begin interpolation transfer can1
        send blocks = can, can_lid, bottom_foam, top_foam
        receive blocks = can, can_lid, bottom_foam, top_foam
      end
      begin interpolation transfer can2
        send blocks = can, can_lid, bottom_foam, top_foam
        receive blocks = can_2, can_lid_2, bottom_foam_2, top_foam_2
      end
    end

    # 
    # We need two time blocks for this example, because in order to be successful
    # with our procedural transfer can #1 and can #2 need to overlap and occupy 
    # the same physical space as the original model.
    #
    # Therefore, time block #1 is used to move the cans into their assembled position.
    # Then, we re-solve for equilibrium since the interpolation process will throw 
    # us slightly out of equilibrium.  Furthermore, we've introduced additional preloads
    # (the gasket between the top and bottom housings) as well as new contacts between
    # the preloaded cans and the housings.
    #  
    begin time control
      begin time stepping block tb_move
        start time = 0.0
        begin parameters for adagio region region1
          number of time steps = 1
        end 
      end
      begin time stepping block tb_equilibrium
        start time = 1.0
        begin parameters for adagio region region1
          number of time steps = 1
        end 
      end 
      termination time = 2.0
    end time control

    begin adagio region region1
      use finite element model two_canisters

      # Original can stays fixed in its transferred position
      begin prescribed velocity
        block = can, can_lid, top_foam, bottom_foam
        component = x
        function = sierra_constant_function_zero
        active periods = tb_move
      end
      begin prescribed velocity
        block = can, can_lid, top_foam, bottom_foam
        component = y
        function = sierra_constant_function_zero
        active periods = tb_move
      end
      begin prescribed velocity
        block = can, can_lid, top_foam, bottom_foam
        component = z
        function = sierra_constant_function_zero
        active periods = tb_move
      end

      # Move can #2 to final location
      begin prescribed velocity
        block = can_2, can_lid_2, top_foam_2, bottom_foam_2
        component = x
        function = sierra_constant_function_one
        scale factor = -8
        active periods = tb_move
      end
      begin prescribed velocity
        block = can_2, can_lid_2, top_foam_2, bottom_foam_2
        component = y
        function = sierra_constant_function_zero
        active periods = tb_move
      end
      begin prescribed velocity
        block = can_2, can_lid_2, top_foam_2, bottom_foam_2
        component = z
        function = sierra_constant_function_zero
        active periods = tb_move
      end

      # Fix housing along top and bottom so that we can preload the gasket during this
      # procedure as well.
      begin fixed displacement
        surface = housing_top_surf, housing_bottom_surf
        components = x y z
      end fixed displacement

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable log_strain to nodal variable log_strain
      end

      begin results output  
        database name = reuse_preloaded_canister.e
        at step 0 increment = 1
        nodal displacement
        nodal von_mises
        nodal log_strain
      end 

      #
      # The contact definition is inactive during the "move" procedure while we assemble
      # the model.  We are using "glued" contact since the parts to be assembled are not
      # in contact in their reference configuration, but are moved and THEN meant to be 
      # tied together in their assembled position.  
      #
      # Note that:
      # - any contacts in the original preloaded model need to be duplicated for each replicate
      # - any new contacts (such as between housing and preloaded parts) need to also be added
      #
      begin contact definition
        active periods = tb_equilibrium

        skin all blocks = on

        begin constant friction model friction
          friction coefficient = 0.9
        end

        begin interaction defaults
          general contact = on
          self contact = off
          friction model = friction
        end

        begin interaction bottom_foam
          side a = can
          side b = bottom_foam
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction top_foam
          side a = can_lid
          side b = top_foam
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction can
          surfaces = can can_lid
          friction model = glued
        end

        begin interaction bottom_foam_2
          side a = can_2
          side b = bottom_foam_2
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction top_foam_2
          side a = can_lid_2
          side b = top_foam_2
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction can_2
          surfaces = can_2 can_lid_2
          friction model = glued
        end

        begin constant friction model light_friction
          friction coefficient = 0.5
        end

        begin interaction housing
          side a = housing_top, housing_bottom
          side b = gasket
          friction model = light_friction
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction
          side a = housing_bottom
          side b = can, can_2
          normal tolerance = 0.05
          friction model = glued
        end
      end
      
      #
      # The load step predictor is disabled for the first step of a new time block "scale factor = 1 0"
      # because of the large motion that happens during the assembly process.  Including that motion in 
      # a predicted solution will cause the solver to fail terribly.
      #
      begin solver
        begin loadstep predictor
          type = scale_factor
          scale factor = 1 0
        end
        begin cg
          target relative residual = 1.0e-4
          maximum iterations = 40
          begin full tangent preconditioner
            nodal preconditioner = probe
            small number of iterations = 10
          end
        end

        begin control contact
          target relative residual = 1.0e-3
        end
      end

    end #region
  end #procedure
end #sierra

