begin sierra gasket
  begin material foam
    density = 2.5e-4
    begin parameters for model elastic
      youngs modulus = 150
      poissons ratio = 0.35
    end 
  end

  begin material aluminum
    density = 2.5e-4
   
    begin parameters for model elastic
      youngs modulus = 10e6
      poissons ratio = 0.33
    end 
  end

  begin finite element model canister
    database name = canister.g

    begin parameters for block bottom_foam top_foam
      material = foam
      model = elastic
      hourglass stiffness = 0.2
    end 

    begin parameters for block can can_lid
      material = aluminum
      model = elastic
      hourglass stiffness = 0.2
    end 
  end

  begin function move_lid
    type = piecewise linear
    begin values
      0.0  0.0
      0.5  -0.6   # foam initial contact
      1.0  -1.1   # full lid contact
    end

  end

  begin adagio procedure adagio_proc1
    begin time control
      begin time stepping block tb_lid_move
        start time = 0.0
        begin parameters for adagio region region1
          number of time steps = 5
        end 
      end 

      begin time stepping block tb_foam_contact
        start time = 0.5
        begin parameters for adagio region region1
          number of time steps = 15
        end 
      end 
      termination time = 1.0
    end time control

    begin adagio region region1
      use finite element model canister

      # Fixed can on bottom surface
      begin fixed displacement
        surface = can_bottom
        components = x y z
      end fixed displacement

      # Fixed bottom foam while moving into contact
      # release (inactive) bottom foam once contact can take over
      begin fixed displacement
        block = bottom_foam
        components = x y z
        active periods = tb_lid_move
      end fixed displacement

      # Move lid and top foam downward and into contact
      # release (inactive) top foam once contact can take over.
      begin prescribed displacement
        block = can_lid 
        component = y
        function = move_lid
      end
      begin fixed displacement
        surface = lid_threads
        component = x z
      end
      begin prescribed displacement
        block = top_foam
        component = y
        function = move_lid
        active periods = tb_lid_move
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable log_strain to nodal variable log_strain
      end

      begin results output  
        database name = preloaded_canister.e
        at step 0 increment = 1
        nodal displacement
        nodal von_mises
        nodal log_strain
        element unrotated_stress
        element left_stretch
        element rotation
      end 

      begin contact definition
        skin all blocks = on

        begin constant friction model friction
          friction coefficient = 0.9
        end

        begin interaction defaults
          general contact = on
          self contact = off
          friction model = friction
        end

        begin interaction bottom_foam
          side a = can
          side b = bottom_foam
          constraint formulation = node_face
          al penalty = 100 1
        end

        begin interaction top_foam
          side a = can_lid
          side b = top_foam
          constraint formulation = node_face
          al penalty = 100 1
        end
      end
       
      begin solver
        begin cg
          target residual = 1.0e-7 during tb_lid_move
          target relative residual = 1.0e-4
          maximum iterations = 40
          begin full tangent preconditioner
            nodal preconditioner = probe
            small number of iterations = 10
          end
        end

        begin control contact
          target residual = 1.0e-7 during tb_lid_move
          target relative residual = 1.0e-3
        end
      end

      begin restart data
        output database name = preloaded_canister.rst
        additional times = 1.0
      end

    end #region
  end #procedure
end #sierra

