begin sierra OringPreload
  begin material aluminum
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin material generic_oring
    density = 7.5e-2

    begin parameters for model elastic
      youngs modulus = 28.0e3
      poissons ratio = 0.45
    end
  end

  begin finite element model fem1
    database name = oring.g

    begin parameters for block bottom_block top_block
      material = aluminum
      model = elastic_plastic
    end

    begin parameters for block oring
      material = generic_oring
      model = elastic
    end
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.0
        begin parameters for adagio region adagio_region
          number of time steps = 1
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model fem1

      begin fixed displacement
        surface = top, bottom
        component = x y z
      end
      begin fixed displacement
        surface = quarter_sym_x
        component = x
      end
      begin fixed displacement
        surface = quarter_sym_y
        component = y
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output results_output
        database name = oring.e
        at step 0, increment = 1
        nodal displacement, velocity
        nodal von_mises, eqps
        nodal contact_status, force_contact
        element hourglass_energy
        element internal_energy
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
            general contact = on
            developer command: group interactions = false
        end

        begin constant friction model fric
          friction coefficient = 0.8
        end

        begin remove initial overlap
        end

        begin interaction oring
          side a = top_block, bottom_block
          side b = oring
          friction model = fric
          remove overlap from none
        end
      end

      begin solver
      end

      # Light solution verification to make sure we have a solution
      # with non-zero stresses
      begin user output
        block = oring
        compute at every step
        compute global max_vm as max of element von_mises
      end
      begin solution verification
        skip times = 0 to 0.9
        completion file = verifErr
        verify global max_vm > 2000
        verify global max_vm < 5000
      end

    end # region
  end # procedure
end # sierra
