begin sierra RotateAndDrop

  begin material aluminum
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin material steel
    density = 7.5e-4

    begin parameters for model elastic
      youngs modulus = 28.0e6
      poissons ratio = 0.30
    end

    begin parameters for model elastic_plastic
      youngs modulus = 28.0e6
      poissons ratio = 0.30
      yield stress = 30e3
      hardening modulus = 30e4
    end
  end

  begin finite element model fem1
    database name = preload_and_drop.g

    begin parameters for block case_aft case_fwd
      material = aluminum
      model = elastic_plastic
    end

    begin parameters for block case_bolt case_bolt_shaft
      material = steel
      model = elastic_plastic
    end

    begin parameters for block plate
      material = steel
      model = elastic
    end
  end

#********************************************
#
# PROCEDURE 2: Apply a rigid body rotation (implicit)
#
#********************************************
  ${rotate_angle = 45}
  ${rotate_point = "0. -2. -6."}
  ${rotate_direction = "1. 0. 0."}
  ${fixed_blocks = "plate"}
  ${write_restart = 0}
  ${include("rotate_procedure.i")}
    

#********************************************
#
# PROCEDURE 3: Drop onto a rigid plate (explicit)
#
#********************************************
  begin adagio procedure ExplicitDropProcedure
    begin procedural transfer
      include all blocks
    end

    begin time control
      begin time stepping block step_2
        start time = 1.0
        begin parameters for presto region drop_region
        end
      end
      termination time = 1.0002
    end

    begin adagio region drop_region
      use finite element model fem1

      begin node based time step parameters
      end
      begin mass scaling
        include all blocks
        target time step = 8.0e-8
      end

      begin fixed displacement
        surface = plate_fixed
        component = x y z
      end

      begin initial velocity
        include all blocks
        remove block = plate
        component = y
        magnitude = {-140*12}
      end
  
      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable eqps to nodal variable eqps
      end
  
      begin results output results_output
        database name = output.e
        database type = exodusII
        at time 1.0, increment = 1.0e-5
  
        nodal variables = displacement, velocity
        nodal variables = von_mises, eqps
        element variables = hourglass_energy
        element variables = internal_energy
      end
  
      begin contact definition
        skin all blocks = on
        begin interaction defaults
            general contact = on
        end
      end

      begin user output
        include all blocks
        compute at every step
        compute global max_eqps as max of nodal eqps
      end

      begin user output
        block = case_bolt_shaft
        compute at every step
        compute global max_bolt_vm as max of element von_mises
      end

      begin solution verification
        skip times = 0 to 1.00019
        completion file = verifErr
        verify global max_eqps > 0.05
        verify global max_bolt_vm > 30e3
      end
    end # explicit region
  end # explicit procedure

end # sierra
