
  begin function rotate
    type = constant
    begin values
      {-PI*rotate_angle/180}
    end
  end
  define point rotatePoint with coordinates {rotate_point}
  define direction rotateDir with vector {rotate_direction}
  define axis rotateAxis with point rotatePoint direction rotateDir

  begin adagio procedure RotateProcedure
    {if(write_restart == 1)}
    begin procedural transfer
        include all blocks
    end
    {endif}

    begin time control
      begin time stepping block step_2
        start time = 0.0
        begin parameters for adagio region rotate_region
            number of time steps = {rotate_angle*2}
        end
      end
      termination time = 1.0
    end

    begin adagio region rotate_region
      use finite element model fem1
       
      begin restart data
      {if(write_restart == 1)}
        output database name = restart_preloaded_state.e
        additional times = 0.0
      {elseif(write_restart == 0)}
        input database name = restart_preloaded_state.e
        restart time = 0.0
      {endif}
      end

      #
      # Rotate the preloaded model
      #
      begin prescribed velocity
        include all blocks
        remove block = {fixed_blocks}
        cylindrical axis = rotateAxis
        function = rotate
      end
      begin prescribed velocity
        include all blocks
        remove block = {fixed_blocks}
        radial axis = rotateAxis
        function = sierra_constant_function_zero
      end
      begin prescribed velocity
        include all blocks
        remove block = {fixed_blocks}
        component = x
        function = sierra_constant_function_zero
      end

      #
      # Fixed plate
      #
      begin prescribed velocity
        block = {fixed_blocks}
        component = x
        function = sierra_constant_function_zero
      end
      begin prescribed velocity
        block = {fixed_blocks}
        component = y
        function = sierra_constant_function_zero
      end
      begin prescribed velocity
        block = {fixed_blocks}
        component = z
        function = sierra_constant_function_zero
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable eqps to nodal variable eqps
        compute global max_vm as max of element von_mises
      end

      begin results output results_output
        database name = output_rotation.e
        at time 0, increment = 0.1
        nodal variables = displacement, velocity
        nodal variables = von_mises, eqps
        element variables = hourglass_energy
        element variables = internal_energy
      end

      #
      # May need to adjust solver tolerances manually on bigger models
      #
      begin solver
        begin cg
          minimum iterations = 2
        end
      end
    end # rotate region
  end # rotate procedure
    
