begin sierra PreloadOnly

  begin material aluminum
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin material steel
    density = 7.5e-4

    begin parameters for model elastic
      youngs modulus = 28.0e6
      poissons ratio = 0.30
    end

    begin parameters for model elastic_plastic
      youngs modulus = 28.0e6
      poissons ratio = 0.30
      yield stress = 30e3
      hardening modulus = 30e4
    end
  end

  begin finite element model fem1
    database name = preload_and_drop.g

    begin parameters for block case_aft case_fwd
      material = aluminum
      model = elastic_plastic
    end

    begin parameters for block case_bolt case_bolt_shaft
      material = steel
      model = elastic_plastic
    end

    begin parameters for block plate
      material = steel
      model = elastic
    end
  end

#********************************************
#
# PROCEDURE 1: Apply preload to bolts (implicit)
#
#********************************************
  begin adagio procedure ImplicitPreloadProcedure
    begin time control
      begin time stepping block step_1
        start time = -1.0
        begin parameters for adagio region adagio_region
          number of time steps = 10
        end
      end
      termination time = 0.0
    end

    begin adagio region adagio_region
      use finite element model fem1

      begin fixed displacement
        surface = plate_fixed, case_fwd_front
        component = x y z
      end

      begin preload
        preload bolt case_bolt_shaft to target internal force = 80
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output results_output
        database name = output_preload.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement, velocity
        nodal variables = von_mises, eqps
        element variables = hourglass_energy
        element variables = internal_energy
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
            general contact = on
        end
      end
    
      #
      # Settings here are adjusted to achieve a rapid preload solution
      #
      begin solver
        begin cg
            reference = belytschko
            target relative residual = 1.0e-3
            acceptable relative residual = 1000
            maximum iterations = 20
            begin full tangent preconditioner
              small number of iterations = 10
            end
        end
        begin control contact
            lagrange acceptable relative gap = 0.10
            lagrange tolerance = 0.02
        end
      end
    end # preload region
  end # preload procedure

#********************************************
#
# PROCEDURE 2: Apply a rigid body rotation (implicit)
#
#********************************************
  ${rotate_angle = 45}
  ${rotate_point = "0. -2. -6."}
  ${rotate_direction = "1. 0. 0."}
  ${fixed_blocks = "plate"}
  ${write_restart = 1}
  ${include("rotate_procedure.i")}
    
end # sierra
