begin sierra preload_pad
  begin function squish_x
    type = analytic
    expression variable: t = global time
    expression variable: val = nodal squish_dir(x)
    evaluate expression = "(t/10)*val"
  end
  begin function squish_y
    type = analytic
    expression variable: t = global time
    expression variable: val = nodal squish_dir(y)
    evaluate expression = "(t/10)*val"
  end
  begin function squish_z
    type = analytic
    expression variable: t = global time
    expression variable: val = nodal squish_dir(z)
    evaluate expression = "(t/10)*val"
  end

  begin material steel
    density         = 7.3240e-4
    begin parameters for model elastic
      youngs modulus  = 30.e6
      poissons ratio  = 0.3
    end parameters for model elastic
  end
  begin material pad
    density         = 1.0e-4
    begin parameters for model elastic
      youngs modulus  = 5000
      poissons ratio  = 0.0
    end 
  end

  begin finite element model mesh1
    database name = oversize_cylinder_pad_r1.g

    begin parameters for block block_1 block_3
      material = steel
      model = elastic
      hourglass stiffness = 0.2  # needed to combat hourglassing from contact forces
      hourglass viscosity = 0.2  # needed to combat hourglassing from contact forces
    end
    begin parameters for block block_2
      material = pad
      model = elastic
      hourglass stiffness = 0.2  # needed to combat hourglassing from contact forces
      hourglass viscosity = 0.2  # needed to combat hourglassing from contact forces
      effective moduli model = probed
    end
  end 

  begin adagio procedure PreloadCurvedPad
    begin time control
        begin time stepping block shrink_pad
          start time = 0.0
          begin parameters for adagio region AdagioRegion1
            time increment = 1.0
          end 
        end
        begin time stepping block grow_pad
          start time = 10.0
          begin parameters for adagio region AdagioRegion1
            time increment = 1.0
          end 
        end
        termination time = 11
    end time control

    begin adagio region AdagioRegion1
      use finite element model mesh1

      # Fix exterior surfaces of the constraining steel cylinders
      begin fixed displacement
        surface = sideset_1, sideset_2
        component = x y z
      end
      begin fixed displacement
        nodeset = nodeset_1
        component = x y z
        active periods = shrink_pad
      end

      # Establish node field to be used for prescribed displacement
      begin user variable squish_dir
        type = node vector
        initial value = 0. 0. 0.
      end

      # Populate the node field on surfaces to have prescribed motion,
      # the interior and exterior surfaces of the pad.
      begin initial condition
        surface = pad_inside
        variable type = node
        initialize variable name = squish_dir
        calculate as closest projection to surface = wall_inside
      end
      begin initial condition
        surface = pad_outside
        variable type = node
        initialize variable name = squish_dir
        calculate as closest projection to surface = wall_outside
      end
       
      # Apply the pad displacements individual to X, Y, Z components.
      # Use analytic functions which "read" the node field.
      begin prescribed displacement
        surface = pad_inside, pad_outside
        function = squish_x
        component = x
        scale factor = 2.0
        active periods = shrink_pad
      end
      begin prescribed displacement
        surface = pad_inside, pad_outside
        function = squish_y
        component = y
        scale factor = 2.0
        active periods = shrink_pad
      end
      begin prescribed displacement
        surface = pad_inside, pad_outside
        function = squish_z
        component = z
        scale factor = 2.0
        active periods = shrink_pad
      end

      # Activate the contact definition during the growth phase.
      begin contact definition
        skin all blocks = on
        begin interaction defaults
          general contact = on
          friction model = rubber_to_steel
        end
        begin constant friction model rubber_to_steel
          friction coefficient = 0.9
        end

        active periods = grow_pad
      end

      # We use a few non-default settings here to assist the solver.
      begin solver
        begin cg
          target relative residual = 0.5e-3
          acceptable relative residual = 100
          maximum iterations = 200
          preconditioner = probe
        end
        begin control contact
          target relative residual = 1.0e-3
        end
      end

      begin results output
        database name = output_displacement_based.e
        at step 0, increment = 1
        nodal displacement
        nodal velocity
        nodal force_contact
        nodal squish_dir
        element log_strain
        element von_mises
        element stress
        global contact_force_norm
        global net_contact_force
      end 

      begin user output
        block = block_2
        compute at every step
        compute global contact_force_norm as l2norm of nodal force_contact
        compute global max_vm as max of element von_mises
      end
      begin user output
        surface = pad_inside
        compute global net_contact_force as sum of nodal force_contact
      end

    end #region 
  end #procedure

end #sierra
