begin sierra preload_pad
  define direction pad1normal with vector  1 1 0
  define direction pad2normal with vector  1 0 0
  define direction pad3normal with vector -1 1 0

  begin function constant_function_negative_one
    type = constant
    begin values
      -1
    end
  end
  
  begin function shrink_and_grow
    type = piecewise linear
    begin values
      0.0 0.0  # start at undeformed size
      1.0 1.0  # shink to nominal deformed size
      2.0 0.0  # return to undeformed size, but now constrained
    end
  end

  begin material steel
    density         = 7.3240e-4
    begin parameters for model elastic
      youngs modulus  = 30.e6
      poissons ratio  = 0.3
    end parameters for model elastic
  end
  begin material pad
    density         = 1.0e-4
    begin parameters for model elastic
      youngs modulus  = 5000
      poissons ratio  = 0.0
    end 
  end

  begin finite element model mesh1
    database name = angled_flat_pad.g

    begin parameters for block back_plate front_plate
      material = steel
      model = elastic
    end
    begin parameters for block pad1 pad2 pad3
      material = pad
      model = elastic
    end
  end 

  begin adagio procedure FlatPadProc
    begin time control
        begin time stepping block shrink_pad
          start time = 0.0
          begin parameters for adagio region AdagioRegion
            time increment = 0.1
          end 
        end
        begin time stepping block grow_pad
          start time = 1.0
          begin parameters for adagio region AdagioRegion
            time increment = 0.05
          end 
        end
        termination time = 2.0
    end time control

    begin adagio region AdagioRegion
      use finite element model mesh1

      begin fixed displacement
        surface = sideset_1, sideset_2
        component = x y z
      end

{if(option=="a")}
      begin artificial strain
        block = pad1
        direction pad1normal function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad2
        direction pad2normal function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad3
        direction pad3normal function = shrink_and_grow scale factor = -0.6
      end
{elseif(option=="b")}
      begin user variable pad1_dir
        block = pad1
        type = element vector
        initial value = 1 1 0
      end
      begin user variable pad2_dir
        block = pad2
        type = element vector
        initial value = 1 0 0
      end
      begin user variable pad3_dir
        block = pad3
        type = element vector
        initial value = -1 1 0
      end

      begin artificial strain
        block = pad1
        direction field pad1_dir function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad2
        direction field pad2_dir function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad3
        direction field pad3_dir function = shrink_and_grow scale factor = -0.6
      end
{elseif(option=="c")}
      begin user variable pad1_dir
        block = pad1
        type = element vector
        initial value = 1 0 0
      end
      begin user variable pad2_dir
        block = pad2
        type = element vector
        initial value = 1 0 0
      end
      begin user variable pad3_dir
        block = pad3
        type = element vector
        initial value = 1 0 0
      end

      begin user output compute_pad1_dir
        block = pad1
        compute element pad1_dir(x) as function sierra_constant_function_one
        compute element pad1_dir(y) as function sierra_constant_function_one
        compute element pad1_dir(z) as function sierra_constant_function_zero
      end

      begin user output compute_pad2_dir
        block = pad2
        compute element pad2_dir(x) as function sierra_constant_function_one
        compute element pad2_dir(y) as function sierra_constant_function_zero
        compute element pad2_dir(z) as function sierra_constant_function_zero
      end

      begin user output compute_pad3_dir
        block = pad3
        compute element pad3_dir(x) as function constant_function_negative_one
        compute element pad3_dir(y) as function sierra_constant_function_one
        compute element pad3_dir(z) as function sierra_constant_function_zero
      end

      begin artificial strain
        block = pad1
        direction field pad1_dir function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad2
        direction field pad2_dir function = shrink_and_grow scale factor = -0.6
      end
      begin artificial strain
        block = pad3
        direction field pad3_dir function = shrink_and_grow scale factor = -0.6
      end
{endif}

      begin contact definition
        active periods = grow_pad
        skin all blocks = on

        begin constant friction model rubber_to_steel
          friction coefficient = 0.9
        end

        begin interaction defaults
          general contact = on
          friction model = rubber_to_steel
        end

        begin interaction pad
          side a = back_plate, front_plate
          side b = pad1, pad2, pad3
          constraint formulation = node_face
          al penalty = 5
        end
      end

      begin solver
      end

      begin results output
        database name = output.e
        at step 0, increment = 1
        nodal displacement
        nodal velocity
        nodal force_contact
        nodal von_mises
        element stress
      end 

      begin user output
        extrapolate element variable von_mises to nodal variable von_mises
      end


      begin user output
        block = pad1
        compute at every step
        compute element minStrainXPad1_element as min over time of element artificial_strain(xx)
        compute global minStrainXPad1 as min of element minStrainXPad1_element
        compute element minStrainYPad1_element as min over time of element artificial_strain(yy)
        compute global minStrainYPad1 as min of element minStrainYPad1_element
      end
      begin user output
        block = pad2
        compute at every step
        compute element minStrainXPad2_element as min over time of element artificial_strain(xx)
        compute global minStrainXPad2 as min of element minStrainXPad2_element
        compute element minStrainYPad2_element as min over time of element artificial_strain(yy)
        compute global minStrainYPad2 as min of element minStrainYPad2_element
      end
      begin user output
        block = pad3
        compute at every step
        compute element minStrainXPad3_element as min over time of element artificial_strain(xx)
        compute global minStrainXPad3 as min of element minStrainXPad3_element
        compute element minStrainYPad3_element as min over time of element artificial_strain(yy)
        compute global minStrainYPad3 as min of element minStrainYPad3_element
      end

      begin solution verification
        skip times = 0 to 0.9
        completion file = verifErr
        verify global minStrainXPad1 = -0.3 plus or minus 0.005
        verify global minStrainXPad2 = -0.6 plus or minus 0.005
        verify global minStrainXPad3 = -0.3 plus or minus 0.005

        verify global minStrainYPad1 = -0.3 plus or minus 0.005
        verify global minStrainYPad2 =  0.0 plus or minus 0.005
        verify global minStrainYPad3 = -0.3 plus or minus 0.005
      end

    end #region 
  end #procedure
end #sierra
