begin sierra gasket
  begin material gasket
    density = 2.5e-4
   
    begin parameters for model elastic_plastic
      youngs modulus = 10e4
      poissons ratio = 0.33
      yield stress = 2500
      hardening modulus = 10e2
    end 
  end

  begin material steel
    density = 7.32e-4
   
    begin parameters for model elastic_plastic
      youngs modulus = 30e6
      poissons ratio = 0.29
      hardening modulus = 150e3
    end 
  end

  begin finite element model mesh1
    database name = gasket_preload.g

    begin parameters for block gasket
      material = gasket
      model = elastic_plastic
    end 

    begin parameters for block housing_top housing_bottom
      material = steel
      model = elastic_plastic
    end 
  end

  begin adagio procedure adagio_proc1
    begin time control
      begin time stepping block preload_gasket
        start time = 0.0
        begin parameters for adagio region region1
          number of time steps = 1
        end 
      end 
      termination time = 1.0
    end time control

    begin adagio region region1
      use finite element model mesh1

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable log_strain to nodal variable log_strain
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output  
        database name = output.e
        at step 0 increment = 1
        nodal displacement
        nodal von_mises
        nodal log_strain
        nodal eqps
      end 

      begin fixed displacement
        surface = housing_top_surf, housing_bottom_surf
        components = x y z
      end fixed displacement

      begin contact definition
        skin all blocks = on

        begin constant friction model light_friction
          friction coefficient = 0.5
        end

        begin interaction defaults
          general contact = on
          self contact = off
        end

        begin dash options
          search length scaling = 0.05
        end

        begin interaction int1
          side a = housing_top, housing_bottom
          side b = gasket
          friction model = light_friction
          constraint formulation = node_face
          al penalty = 100 1
          normal tolerance = 0.0
        end
      end
       
      begin solver
        begin cg
          begin full tangent preconditioner
            nodal preconditioner = probe
            small number of iterations = 10
          end
        end
      end

    end #region
  end #procedure
end #sierra

