begin sierra preload_training
  begin material steel
    density         = 7.45e-4
    begin parameters for model elastic
      poissons ratio  = 0.27
      youngs modulus  = 28e6
    end 
  end

  begin finite element model mesh1
    database Name = rv_sled.g

    begin parameters for block
      include all blocks
      material = steel
      model = elastic
    end
  end

  begin presto procedure proc1
    begin time control
      begin time stepping block preload
        start time = 0.0
        begin parameters for adagio region region1
            number of time steps = 10
        end
      end

      termination time = 1.0
    end time control

    begin adagio region region1
      use finite element model mesh1

      begin fixed displacement
        block = rails
        sideset = sled_bottom, rod_ends
        component = x y z
      end
      begin fixed displacement
        sideset = fixture_bottom
        component = x z
      end

      begin user output
        block = shank1
        compute global net_axial_force_shank1 as internal reaction normal in defined direction sierra_direction_y
      end
      begin user output
        block = shank2
        compute global net_axial_force_shank2 as internal reaction normal in defined direction sierra_direction_y
      end

      begin results output
        database name = output.e
        at time 0.0, interval = 1e-5
        nodal displacement 
        nodal velocity
        nodal contact_status
        element von_mises
        global sm_preload_axial_force_shank1
        global sm_preload_axial_force_shank2
        global net_axial_force_shank1 
        global net_axial_force_shank2 
      end

      begin contact definition
        contact surface s1 contains shank1
        contact surface s2 contains shank2
        contact surface h1 contains head1
        contact surface h2 contains head2
        contact surface fixture contains fixture
        contact surface sled contains sled
        contact surface rv contains cone

        begin interaction defaults 
          general contact = on
          self contact = off
          constraint formulation = node_face
          friction model = tied
        end

        begin interaction
          surfaces = fixture sled
          interaction behavior = no_interaction
        end
        begin interaction
          surfaces = s1 s2 sled
          interaction behavior = no_interaction
        end
      end

      begin solver
        begin cg
          begin full tangent preconditioner
            small number of iterations = 10
          end
        end
      end

    end #region
  end #procedure
end #sierra

