begin sierra bolt_preload
  begin material steel
    density         = 7.45e-4
    begin parameters for model elastic
      poissons ratio  = 0.27
      youngs modulus  = 28e6
    end 
  end

  begin finite element model mesh1
    database Name = bolt_preload.g

    begin parameters for block
      include all blocks
      material = steel
      model = elastic
    end
  end

  begin presto procedure Apst_Procedure
    begin time control
      begin time stepping block preload
        start time = 0.0
        begin parameters for presto region presto
        end
      end

      termination time = 0.002
    end time control

    begin presto region presto
      use finite element model mesh1

      begin preload
        preload bolt bolt_shank_1 to target average von_mises = 70e3
        preload bolt bolt_shank_2 to target average von_mises = 70e3
{if(version=="adaptive")}
        solver adaptivity = on
{elseif(version=="pid")}
        explicit control algorithm = pid
{endif}
      end

      begin results output output_presto
        database name = output.e
        at time 0.0, interval = 1e-5
        nodal displacement 
        nodal velocity
        nodal acceleration
        element von_mises
        element artificial_strain
        global sm_preload_average_von_mises_bolt_shank_1 as avg_von_mises_bolt1
        global sm_preload_average_von_mises_bolt_shank_2 as avg_von_mises_bolt2
      end

      begin contact definition
        contact surface c1 contains bottom_plate_2
        contact surface c2 contains top_plate_2
        contact surface c3 contains bolt_head_2
        begin interaction defaults 
          general contact = on
          self contact = off
          constraint formulation = node_face
{if(version=="adaptive") || version=="pid"}
        friction model = light_friction
{else}
        friction model = tied
{endif}
        end
        begin constant friction model light_friction
          friction coefficient = 0.1
        end
      end

      begin solution verification
        completion file = verifErr
        skip times = 0 to 0.0015
        verify global sm_preload_average_von_mises_bolt_shank_1 = 70000 plus or minus 1000
        verify global sm_preload_average_von_mises_bolt_shank_2 = 70000 plus or minus 1000
      end

    end presto region presto
  end presto procedure Apst_Procedure
end sierra bolt_preload

