begin sierra bolt_preload
  define direction z_axis with vector 0.0 0.0 1.0

  begin function bolt_preload
    type = piecewise linear
    begin values
      0.0     0.0
      0.001   -1.0   # Apply preload
      0.002   -1.0   # Hold preload, ensure quasi-static
    end
  end

  begin material steel
    density         = 7.45e-4
    begin parameters for model elastic
      poissons ratio  = 0.27
      youngs modulus  = 28e6
    end 
  end

  begin finite element model mesh1
    database Name = bolt_preload.g

    begin parameters for block
      include all blocks
      material = steel
      model = elastic
    end
  end

  begin presto procedure Apst_Procedure
    begin time control
      begin time stepping block preload
        start time = 0.0
        begin parameters for presto region presto
        end
      end

      termination time = 0.002
    end time control

    begin presto region presto
      use finite element model mesh1

      begin artificial strain
        block = bolt_shank_1
        direction z_axis function = bolt_preload scale factor = 0.0051
      end

      begin artificial strain
        block = bolt_shank_2
        direction z_axis function = bolt_preload scale factor = 0.0151
      end

      begin results output output_presto
        database name = output.e
        at time 0.0, interval = 1e-5
        nodal displacement 
        nodal velocity
        nodal acceleration
        element von_mises
        element artificial_strain
        global avg_von_mises_bolt1
        global avg_von_mises_bolt2
      end

      begin history output
        Database Name = bolt_preload.h
        at time 0.0, interval = 1.0e-6
        global avg_von_mises_bolt1 
        global avg_von_mises_bolt2
      end

      begin user output
        block = bolt_shank_1
        compute global avg_von_mises_bolt1 as average of element von_mises
      end

      begin user output
        block = bolt_shank_2 
        compute global avg_von_mises_bolt2 as average of element von_mises 
      end

      begin contact definition
        contact surface c1 contains bottom_plate_2
        contact surface c2 contains top_plate_2
        contact surface c3 contains bolt_head_2
        begin interaction defaults 
          general contact = on
          self contact = off
          constraint formulation = node_face
          friction model = tied
        end
        begin constant friction model light_friction
          friction coefficient = 0.1
        end
      end

      begin solution verification
        completion file = verifErr
        skip times = 0 to 0.0015
        verify global avg_von_mises_bolt1 = 70000 plus or minus 1000
        verify global avg_von_mises_bolt2 = 70000 plus or minus 1000
      end

    end presto region presto
  end presto procedure Apst_Procedure
end sierra bolt_preload

