begin sierra
    begin material generic
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 500.
            poissons ratio = 0.4
        end
    end

    begin finite element model pad
        database name = direct_compression.e
        begin block
            include all blocks
            material = generic
            model = elastic
        end
    end

    begin adagio procedure proc1
        begin time control
            begin time stepping block tb1
                start time = 0.0
                begin parameters for adagio region region1
                    time increment = 1.0
                end
            end
            termination time = 1.0
        end

        begin adagio region region1
            use finite element model pad

            #
            # This is the primary purpose of this input deck: we read in the updated "coordinates"
            # and set our "model_coordinates" equal to them.  Now, we can use this mesh as the starting
            # point for other analyses.
            #
            begin initial condition
              include all blocks
              initialize variable name = model_coordinates
              variable type = node
              read variable = coordinates
              time = last
            end

            begin fixed displacement
              include all blocks
              component = x y z
            end

            begin solver
            end

            begin results output
                database name = deformed_config_pad_with_holes.g
            end

        end #region
    end #procedure
end #sierra

