begin sierra
    begin material generic
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 500.
            poissons ratio = 0.4
        end
    end

    begin material stiff
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 50000.
            poissons ratio = 0.0
        end
    end

    begin function push_pad
      type = piecewise linear
      begin values
        0.0 0.0
        1.0 0.2
      end
    end

    begin finite element model pad
        database name = pad_with_holes.g
        begin parameters for block block_1
            material = generic
            model = elastic
            hourglass stiffness = 0.2
        end
        begin parameters for block block_2 block_3
            material = stiff
            model = elastic
        end
    end

    begin adagio procedure proc1
        begin time control
            begin time stepping block tb1
                start time = 0.0
                begin parameters for adagio region region1
                    time increment = 0.1
                end
            end
            termination time = 1.0
        end

        begin adagio region region1
            use finite element model pad

            begin fixed displacement
              block = block_2, block_3
              nodeset = pad_bottom_mid
              component = x y z
            end

            begin fixed displacement
              nodeset = pad_bottom_front
              component = y 
            end

            begin fixed displacement
              surface = pad_bottom
              component = x 
            end

            begin prescribed displacement
              surface = pad_top
              component = x
              function = push_pad
            end

            begin solver
            end

            begin user output
              surface = pad_bottom
              compute global compression_force as sum of nodal reaction(x)
            end

            begin results output
                database name = direct_compression.e
                at time 0, increment = 0.05
                nodal displacement
                nodal force_internal
                nodal coordinates
                element von_mises
                element artificial_strain
                element log_strain
                global compression_force
            end

        end #region
    end #procedure
end #sierra
