begin sierra
    begin material generic
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 150.
            poissons ratio = 0.0  # decouple stress-strain response to get 1D behavior
        end
    end

    begin function strain_ramp
      type = piecewise linear
      begin values
        0.0  {50000 + 0.0}
        0.01 {50000 + 1.0}
      end
    end

    begin finite element model one_brick
        database name = brick.g
        begin parameters for block block_1
            material = generic
            model = elastic
        end
    end

    begin adagio procedure proc1
        begin time control
            begin time stepping block tb1
                start time = 0.0
                begin parameters for adagio region region1
                    time increment = 1.0
                end
            end
            termination time = 1.0
        end

        begin adagio region region1
            use finite element model one_brick

            # Define a simple uniaxial strain
            #  - Using built-in function for strain direction
            begin artificial strain
              block = block_1
              strain type = engineering
              direction sierra_direction_x function = strain_ramp scale factor = 1.0
            end
            
            # Note: we have no boundary conditions but are solving a static problem.
            # This means we technically have 6 rigid body modes that should typically
            # cause convergence issues.  We can "get away" with this for such simple problems.
            begin solver
            end

            begin results output
                database name = output.e
                at time 0, increment = 0.05
                nodal displacement
                nodal force_internal
                element artificial_strain
                element artificial_strain_rate_3d
                element artificial_strain_reference_strain
                element nonmaterial_strain_3d
                element nonmaterial_strain_rate_3d
                element stress(xx) as stress_xx
            end

        end #region
    end #procedure
end #sierra
