begin sierra preload_effects
  begin definition for function load_ramp
    type is piecewise linear
    begin values
      0.    0.
      0.005 1
    end values
  end

  begin material generic_metal
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin material bolt_material
    density = 7e-4
    begin parameters for model elastic
      youngs modulus = 30.0e6
      poissons ratio = 0.3
    end
  end

  begin finite element model preload
    database name = preload_effects.g

    begin parameters for block top_block bottom_block
      material = generic_metal
      model = elastic_plastic
    end

    begin parameters for block bolt_head bolt_shank bolt_thread
      material = bolt_material 
      model = elastic
    end
  end

#
# FIRST PROCEDURE: Perform a basic preload of the system
#
  begin adagio procedure adagio_proc_preload
    begin time control
      begin time stepping block preload
        start time = -1e-4
        begin parameters for adagio region adagio_region_preload
          number of time steps = 5
        end
      end
      termination time = 0.0
    end

    begin adagio region adagio_region_preload
      use finite element model preload

      begin preload
        preload bolt bolt_shank to target internal force = 10
        active periods = preload
      end

      begin fixed displacement
        surface = top_surf
        components = x y z
      end 

      begin fixed displacement
        surface = back_surf
        components = z 
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
          general contact = on
          friction model = frictionless
        end
      end

      begin user output
        block = bolt_shank
        compute global net_bolt_force as internal reaction normal in defined direction sierra_direction_y
      end

      begin results output results_output
        database name = output_preload.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        nodal variables = force_contact
        element variables = eqps
        element variables = von_mises
        element variables = stress
        global variables = net_bolt_force
        global variables = sm_preload_axial_force_bolt_shank_component0
        global variables = sm_preload_strain_bolt_shank_component0
      end

      begin solver
        begin cg
          target relative residual = 0.005
          acceptable relative residual = 1
          reference = belytschko
          begin full tangent preconditioner
            small number of iterations = 50
          end
        end
        begin control contact
          target relative residual = 0.005
        end
      end
    
    end # region
  end # procedure preload


#
# SECOND PROCEDURE: Apply an external loading to the system
#
  begin adagio procedure adagio_proc_load
    begin procedural transfer
      include all blocks
    end

    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region_load
          time increment = 0.0001
        end
      end
      termination time = 0.01
    end

    begin adagio region adagio_region_load
      use finite element model preload

      begin fixed displacement
        surface = top_surf
        components = x y z
      end 

      begin fixed displacement
        surface = back_surf
        components = z 
      end

      begin distributed force
        surface = load_surf
        component = y
        function = load_ramp
        scale factor = -50
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
          general contact = on
          friction model = frictionless
        end
      end

      begin user output
        block = bolt_shank
        compute global net_bolt_force as internal reaction normal in defined direction sierra_direction_y
      end
      begin user output
        block = bottom_block
        compute global bottom_block_force as internal reaction normal in defined direction sierra_direction_y
      end

      begin user output
        block = bottom_block
        compute global applied_force as sum of nodal force_external(y) 
      end

      begin results output results_output
        database name = output_load.e
        database type = exodusII
        at step 0, increment = 1
        #at time 0.0, increment = 0.001

        nodal variables = displacement
        nodal variables = force_external
        nodal variables = force_contact
        element variables = eqps
        element variables = von_mises
        element variables = stress
        global net_bolt_force
        global bottom_block_force
        global applied_force
      end

      begin implicit dynamics
      end

      begin solver
        begin cg
          target relative residual = 0.005
          acceptable relative residual = 1
          reference = belytschko
          line search secant 1.0e-3
          begin full tangent preconditioner
            small number of iterations = 50
          end
        end

        begin control contact
          target relative residual = 0.005
          lagrange acceptable relative gap = 0.05
          lagrange tolerance = 0.01
        end
      end
    end #region
  end #procedure load
end # sierra
