Begin Sierra
  ################ Vectors ###############

  define direction x with vector 1.0 0.0 0.0
  define point origin with coordinates 0.0 0.0 0.0
  define axis x_axis with point origin direction x

  ################ Vectors ###############

  begin function const
    type = constant
    begin values
      1.0
    end
  end function const

  begin function fixed
    type = piecewise linear
    begin values
      0.0  0.0
      1.0  0.0
    end
  end function fixed

  begin function pull
    type = piecewise linear
    begin values
      0.0  0.0
      1.0  1.0
    end
  end function pull

################ Material Properties ################

  begin material Stainless_Steel_440C
    density = 7.304e-3
    begin parameters for model elastic
      youngs modulus = 3.04e7 # source matweb
      poissons ratio = 0.283
    end parameters for model elastic
  end material Stainless_Steel_440C

  begin material Stainless_Steel_305
    density = 7.485e-3
    begin parameters for model elastic
      youngs modulus = 2.80e7 # source matweb
      poissons ratio = 0.283 # assumed
    end parameters for model elastic
  end material Stainless_Steel_305

################ FEA Model ################

  begin shell section ribbon
    thickness = 5.375e-3
    lofting_factor = 0.0
  end shell section ribbon

  begin shell section stamped_ribbon
    thickness = 1.075e-2
    lofting_factor = 0.5
  end shell section stamped_ribbon

  begin shell section crown
    thickness = 5.375e-3
    lofting_factor = 0.5
  end shell section crown

  begin finite element model bearing_load
    database name = SSRI-3332_RA7P25LD.exo
    database type = exodusII

    begin parameters for block block_100
      material Stainless_Steel_440C
      model = elastic
    end parameters for block block_100 

    begin parameters for block block_200
      material Stainless_Steel_440C
      model = elastic
    end parameters for block block_200 

    begin parameters for block block_300
      material Stainless_Steel_305
      model = elastic
      section = ribbon
    end parameters for block block_300

    begin parameters for block block_301
      material Stainless_Steel_305
      model = elastic
      section = stamped_ribbon
    end parameters for block block_301

  end finite element model bearing_load

  begin adagio procedure pull_it

    ################ Time Control ################

    begin time control
      begin time stepping block pull
        start time = 0.0
        begin parameters for adagio region assemble
          number of time steps = 200
        end parameters for adagio region assemble
      end time stepping block pull
      termination time = 1.0
    end time control

############## preload the model ###############
################################################
    begin adagio region assemble
      use finite element model bearing_load

################ Boundary Conditions ################

      begin fixed displacement
        surface = sideset_2001
        component = x
      end fixed displacement

      begin prescribed displacement
        surface = sideset_2001
        radial axis = x_axis
        function = fixed
      end prescribed displacement

      begin prescribed displacement
        surface = sideset_2001
        cylindrical axis = x_axis
        function = fixed
      end prescribed displacement

      begin prescribed displacement
        surface = sideset_2000
        component = x
        function = pull
        scale factor = 0.012
      end prescribed displacement

      begin prescribed displacement
        surface = sideset_2000
        radial axis = x_axis
        function = fixed
      end

      begin prescribed displacement
        surface = sideset_2000
        cylindrical axis = x_axis
        function = fixed
      end


################ Contact Enforcement ################

      begin contact definition contact_pre
        contact surface balls contains block_100
        contact surface races contains block_200
        contact surface cage  contains block_300

        begin interaction defaults
          friction model = sticky
        end interaction defaults

        begin interaction race
          surfaces = balls races
          friction model = sticky
        end interaction race

        begin interaction cage
          surfaces = balls cage
          friction model = sticky
        end interaction cage

        begin constant friction model sticky
          friction coefficient = 0.65 # source engineering toolbox: dry+clean steel on steel -> 0.5 to 0.8
        end constant friction model sticky

      end contact definition contact_pre


      begin user output
        surface  = sideset_2000
        compute global pull_f as sum of nodal reaction
        compute global pull_d as max of nodal displacement
      end user output

      begin history output 
        database name = bearing_pre_and_pull.feti.h
        database type = exodusII
        at time 0.0 increment = 1.0e-4
        global pull_f
        global pull_d
      end history output 

      begin solver
        begin cg
          reference = energy
          target residual = 1.0e-8
          target relative residual = 1.0e-5
          acceptable relative residual = 1.0
          maximum iterations = 50
          minimum iterations = 1
          iteration print = 1
          begin full tangent preconditioner
            linear solver = feti
            tangent diagonal scale = 1.0e-8
            maximum updates for loadstep = 0
            minimum convergence rate = 0.1
          end
        end
        begin control contact
          acceptable residual = 1.0e-5
          acceptable relative residual = 1.0e-2
          target residual = 1.0e-6
          target relative residual = 1.0e-3
          maximum iterations = 50
          minimum iterations = 5
          lagrange adaptive penalty = uniform
        end
      end


      begin adaptive time stepping
        target iterations = 1000000
        cutback factor = 0.9
        growth factor =  1.05
        maximum failure cutbacks = 1000
        minimum multiplier = 1.0e-3
        maximum multiplier = 1.0
      end

    end adagio region assemble

  end adagio procedure pull_it

  begin gdsw equation solver gdsw
  end
  begin feti equation solver feti
  end

End Sierra
