begin sierra CantileverBeam
   
   title This problem imposes a constant gravitational acceleration on a bar along with an initial velocity.
    
   begin function gravity_accel
      type is constant
      begin values
         9.81
      end values
   end function gravity_accel
   
   define direction z_axis with vector 0.0 0.0 1.0
   
   
   begin presto procedure Apst_Procedure
      
      begin time control
         begin time stepping block p1
            start time = 0.0
            begin parameters for presto region presto
               time step scale factor = 1.0
               time step increase factor = 2.0
               step interval = 1
               initial time step = 0.00001
            end parameters for presto region presto
         end time stepping block p1
         
         termination time = 1.e-3
      end time control
      
      begin presto region presto
         
         use finite element model FEM_Name
         
         ### output description ###
         begin results output output_presto
            database name = fext_gravity_bar.e
            database type = exodusII
            at time 0.0 Increment = 0.5e-4
            nodal variables = force_external as f_ext
            nodal variables = force_internal as f_int
            nodal variables = velocity as vel
            nodal variables = acceleration as acc
            nodal variables = displacement as displ
            element variables = stress as stress
            global variables = timestep as timestep
            global variables = external_energy as ExternalEnergy
            global variables = internal_energy as InternalEnergy
            global variables = kinetic_energy as KineticEnergy
            global variables = momentum as Momentum
         end results output output_presto
         
         
         ### definition of BCs ###
         
         
         ### definition of loads ###
         
         begin gravity
            function = gravity_accel
            scale factor = -1.0
            direction = z_axis
            gravitational constant = 1.0
         end gravity
         
         begin fixed displacement fixed
            component = x y z
            surface = surface_1
         end fixed displacement fixed
         begin prescribed force pf
            component = y
            surface = surface_2
            function = sierra_constant_function_one
            scale factor = -10
         end prescribed force pf
         begin user output accelerationComparison
            block = block_1
            compute global global_average as average of nodal acceleration
            compute global avg1 as nonlocal average of nodal acceleration \#
              over domain defined by radius 0.070710678118 and point 0.5 0 0
         end user output accelerationComparison
         begin results output aOut
            database name = averageOverSubdomain.e
            database type = exodusII
            at time 0.0 interval = 1.0e-5
            nodal variables = nonlocal_domains
            nodal variables = var1
            nodal variables = coordinates
            global variables = avg1
            global variables = global_average            
            global variables = tipAcceleration
         end results output aOut
         begin user output nodalAcc
         end user output nodalAcc
         begin user output subsetname
            nodeset = Tip_Acceleration
            compute global tipAcceleration as max of nodal acceleration
         end user output subsetname
      end presto region presto
   end presto procedure Apst_Procedure
   
   begin finite element model FEM_Name
      database name = CantileverBeam.g
      begin parameters for block block_1
         material aluminum
         model = elastic
      end parameters for block block_1
   end finite element model FEM_Name

   begin material aluminum
      density = 2800
      begin parameters for model elastic
         youngs modulus = 73.e9
         poissons ratio = 0.3
      end parameters for model elastic
   end material aluminum
end sierra CantileverBeam
