begin sierra pressurized_can

  title pressurized can

  define direction five_degree_normal with vector 0.995037 0.099504 0.000000

  ############################
  ###  functions           ###
  ############################

  begin function internal_pressure
    type = piecewise linear
    begin values
        0.0         0.0
      300.0  34473786.5
    end values
  end function internal_pressure

  begin function temp_dep_ym_factor
    type = piecewise linear
    begin values
       292.0  2.000
       473.0  1.950
       823.0  1.450
       923.0  0.720
       973.0  0.330
      1723.0  0.002
    end values
  end function temp_dep_ym_factor

  begin function temp_dep_pr_factor
    type = piecewise linear
    begin values
       292.0  1.0
      1671.0  1.5
      1723.0  2.0
      2778.0  2.0
    end values
  end function temp_dep_pr_factor
  
  begin function temp_dep_yield
    type = piecewise linear
    begin values
       200.0  1171735443.603022
       298.0  1171735443.603022
       473.0  931439455.6905556
       673.0  895837788.6294645
       773.0  805432514.3492175
       823.0  700966860.3005524
       873.0  462645341.0167510
       923.0  220825678.7482746
       973.0   90000000.0000000
      1073.0   75000000.0000000
      1273.0   20000000.0000000
      1723.0          0.0000000
    end values
  end function temp_dep_yield

  begin function temp_dep_hardening
    type = piecewise linear
    begin values
      200.0   7274904580.101413
      298.0   7274904580.101413
      473.0  26332108541.729160
      923.0  26332108541.729160
    end values
  end function temp_dep_hardening

  begin function temp_dep_dynamic_recovery
    type = piecewise linear
    begin values
       200.0    37.71455261828839
       298.0    37.71455261828839
       473.0    82.57182478582104
       673.0   135.03000000000000
       773.0   214.92000000000000
       823.0   228.16012878180200
       873.0   177.68492754430470
       923.0   256.71000000000000
       973.0   315.63000000000000
      1273.0  2000.00000000000000
      1723.0  3000.00000000000000
    end values
  end function temp_dep_dynamic_recovery

 begin function temp_dep_misorientation
    type = piecewise linear
    begin values
      200.0  0.01857963212904266
      298.0  0.01857963212904266
      473.0  0.02245550705337919
      673.0  0.02210299572688906
      773.0  0.02033885892352843
      823.0  0.01351865041418932
      873.0  0.01000000000000000
      923.0  0.01000000000000000
    end values
  end function temp_dep_misorientation

  ############################
  ### material properties  ###
  ############################

  begin material steel
    density = 7900.0

    begin parameters for model dsa
      youngs modulus = 100.0e9
      poissons ratio = 0.249
      youngs modulus function = temp_dep_ym_factor
      poissons ratio function = temp_dep_pr_factor
      initial yield function = temp_dep_yield
      kappa hardening function = temp_dep_hardening
      dynamic recovery function = temp_dep_dynamic_recovery
      misorientation variable hardening function = temp_dep_misorientation
      rate independent yield constant = 1
      isotropic hardening constant = 1
      isotropic dynamic recovery constant = 1
      misorientation variable hardening constant = 1
      misorientation variable hardening exponent = 1     
      semi implicit plastic strain solver number of iterations = 1000
      semi implicit plastic strain solver residual tolerance = 1.0e-8
    end parameters for model dsa

  end material steel

  begin finite element model can_model
    database name = pressurized_can.g
    database type = exodusII
    # block_1 : Cover
    # block_2 : Ring
    # block_3 : Can
    begin parameters for block block_1 block_2 block_3 
      material = steel
      model = dsa
    end parameters for block block_1 block_2 block_3 
  end finite element model can_model

  ############################
  ###   adagio procedure   ###
  ############################

  begin adagio procedure adagio_procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio_region
          time increment = 10
        end parameters for adagio region adagio_region
      end time stepping block p1

      begin time stepping block p2
        start time = 150.0
        begin parameters for adagio region adagio_region
          time increment = 0.5
        end 
      end 
      termination time = 300.0
    end time control

    begin adagio region adagio_region
      use finite element model can_model

      begin implicit dynamics
        contact timestep = off
      end

      begin prescribed temperature
        include all blocks
        function = sierra_constant_function_one
        scale factor = 300
      end prescribed temperature

      begin fixed displacement
        surface = surface_4
        component = z
      end fixed displacement

      begin fixed displacement
        surface = surface_2
        component = x
      end fixed displacement

      begin prescribed displacement
        surface = surface_3
        direction = five_degree_normal
        function = SIERRA_CONSTANT_FUNCTION_ZERO
      end prescribed displacement

      begin pressure
        surface = surface_1 surface_11
        function = internal_pressure
        scale factor = 1.0
      end pressure

      begin contact definition sliding
        skin all blocks = off
        contact surface block_1 contains block_1
        contact surface block_2 contains block_2
        contact surface block_3 contains block_3

        begin constant friction model constant_friction
          friction coefficient = 0.3
        end constant friction model constant_friction

        begin interaction defaults
          general contact = on
          self contact = off
          friction model = constant_friction
          al penalty = 0.005
        end interaction defaults

        begin interaction
          side a = block_1
          side b = block_2
          constraint formulation = node_face
        end

        begin interaction
         side a = block_2
         side b = block_3
         normal tolerance = 1.0e-4
        end

      end contact definition sliding

      begin solver
        begin control contact
          target relative residual = 0.01
          acceptable relative residual = 0.02
          minimum iterations = 5
          maximum iterations = 50
          lagrange acceptable relative gap = 0.10
          lagrange adaptive penalty = uniform
        end

        begin cg
          target relative residual = 0.001
          maximum iterations = 20 during p1
          maximum iterations = 120 during p2
          iteration print = 20 during p2
          begin full tangent preconditioner
            minimum smoothing iterations = 100 during p2
            small number of iterations = 10  during p1
            small number of iterations = 110 during p2
          end
        end

        begin loadstep predictor
          type = scale_factor
          scale factor = 0.0
        end
      end

      begin adaptive time stepping
        method = solver_average
        cutback factor = 0.5         during p1
        maximum failure cutbacks = 4 during p1

        #target iterations = 10        during p2
        #iteration window = 5          during p2
        #cutback factor = 0.8          during p2
        #growth factor = 1.2           during p2
        #maximum failure cutbacks = 10 during p2
      end adaptive time stepping

      begin results output
        database name = output.e
        at step 0, increment = 1
        nodal variables = displacement, velocity, acceleration
        nodal variables = contact_status
        element variables = von_mises
      end

    end adagio region adagio_region

  end adagio procedure adagio_procedure
end sierra pressurized_can
