begin sierra bending
  begin function blast_wave
    type = analytic
    ${A = 500}   # Amplitude
    ${width = 5} # pulse width
    ${c = 80e3}  # wave speed
    ${x0 = 5}    # origin_x
    ${y0 = 0}    # origin_y
    ${z0 = 0}    # origin_z
    ${nx = -1}   # propagation direction (x)
    ${ny = 0}    # propagation direction (y)
    ${nz = 0}    # propagation direction (z)
  
  
    # optional, but lets make sure we normalize the direction
    ${ n_mag = sqrt(nx*nx + ny*ny + nz*nz)}
    ${ nx = nx/n_mag}
    ${ ny = ny/n_mag}
    ${ nz = nz/n_mag}
  
    expression variable: t = global time
    expression variable: x = nodal coordinates(x)
    expression variable: y = nodal coordinates(y)
    expression variable: z = nodal coordinates(z)
    evaluate expression = "{A}*haversine_pulse((x - {x0})*{nx} + (y - {y0})*{ny} + (z - {z0})*{nz} - {c}*t, 0.0, {width})"
  end

  begin property specification for material generic_metal
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin finite element model case
    database name = case.g

    begin parameters for block block_1
      material = generic_metal
      model = elastic_plastic
    end
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
          time increment = 1.0e-5
        end
      end
      termination time = 0.001
    end

    begin adagio region adagio_region
      use finite element model case
    
      begin implicit dynamics
      end

      # optionally, add damping
      #begin viscous damping
      #  include all blocks
      #  mass damping coefficients = 600
      #  stiffness damping coefficients = 10e-6
      #end

      begin pressure
        surface = case_exterior
        function = blast_wave
      end 

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement, velocity, acceleration
        nodal variables = von_mises, eqps
        face variables = pressure
        element variables = hourglass_energy
        element variables = internal_energy
      end
    
      begin solver
        begin cg
            target relative residual = 1.0e-3
            maximum iterations = 20
            begin full tangent preconditioner
              small number of iterations = 10
            end
        end
      end
  
    end # region
  end # procedure
end # sierra
