Begin Sierra Axis_Symmetric_Graded

  #### Title Indentation of a thick plate

  ################################################################################

  #### Initialize Directions
  Define Direction posY With Vector 0.0 1.0 0.0

################################################################################

#### Define Functions

  Begin Function Compression
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Displacement
    Begin Values
      0.00  0.0
      0.01  1.0
    End Values
  End Function Compression

################################################################################

#### Define Materials

#### Crushable Foam
  Begin material CF
    Density = 60.0
    Begin Parameters For Model Elastic
      Youngs Modulus = 10E+5
      Poissons Ratio = 0.1
    End Parameters For Model Elastic
  End material CF

  Begin material ALUMINIUM
    Density = 7.4E+4
    Begin Parameters For Model Elastic
      Youngs Modulus = 30.0E6
      Poissons Ratio = 0.333
    End Parameters For Model Elastic
  End material ALUMINIUM

################################################################################

#### Define FEM Model

  Begin Finite Element Model fullgraded
    Database Name = PlateIndentation.g
    Database Type = ExodusII

#### Define Blocks
    Begin Parameters For Block block_1
      Material CF
      Model = Elastic
    End Parameters For Block block_1

    Begin Parameters For Block block_2
      Material ALUMINIUM
      Model = Elastic
    End Parameters For Block block_2

  End Finite Element Model fullgraded

################################################################################

  Begin presto Procedure calculations

    #### Define Time and Time Step

    Begin Time Control
      Termination Time = 1.0E-2
      Begin Time Stepping Block timestep1
        Start Time = 0.0
        Begin Parameters For presto Region Problem
          Step Interval = 100
        End Parameters For presto Region Problem
      End Time Stepping Block timestep1
    End Time Control

################################################################################

    Begin presto Region Problem
      Use Finite Element Model fullgraded

      Begin Results Output axisymmetric_output
        Database Name = PlateIndentation.e
        Database Type = ExodusII
        At Time 0.0 Increment = 5.0E-4
        Nodal Variables = Acceleration As Accel
        Nodal variables = Velocity As Vel
        Nodal Variables = Displacement As Displ
        Nodal Variables = Reaction As Force
        Element Variables = Stress As Stress
        Element Variables = Log_Strain As logstra
        Element Variables = Von_Mises As VonMises
        Element Variables = Effective_Log_Strain As ELS
      End Results Output axisymmetric_output

################################################################################

      Begin Fixed Displacement
        Surface = sideset_1
        Components = X Y Z
      End Fixed Displacement

      Begin Fixed Displacement
        Surface = sideset_6
        Component = X
      End Fixed Displacement

      Begin Fixed Displacement
        Surface = sideset_3
        Component = X
      End Fixed Displacement

      Begin Fixed Displacement
        Surface = sideset_7
        Component = Z
      End Fixed Displacement

      Begin Fixed Displacement
        Surface = sideset_4
        Component = Z
      End Fixed Displacement

      Begin Prescribed Displacement
        #Surface = sideset_8
        Block = block_2
        Direction = posY
        Function = Compression
        scale factor = -0.2
      End Prescribed Displacement

################################################################################

#### Contact

      Begin Contact Definition fullgraded
        Skin all blocks = ON
        Search = dash
        Enforcement = al
        begin interaction defaults
          friction model = CTF
          general contact = on
          self contact  = off
          constraint formulation = node_face
          al penalty = 1.25
        end
        begin dash options
          subdivision level = 5
          interaction definition scheme = explicit
        end
        Begin Constant Friction Model CTF
          Friction Coefficient = 0.1
        End Constant Friction Model CTF
      End Contact Definition fullgraded

      Begin Solver
        begin loadstep predictor
          type = scale_factor
          scale factor = 0.0
        end
        begin control contact
          target relative residual = 1.0E-3
          Maximum Iterations       = 200
          minimum iterations       = 5
          iteration plot           = 1
        end
        Begin cg
          reference = belytschko
          target relative residual = 1.0E-4
          maximum iterations       = 25
          begin full tangent preconditioner
            linear solver = feti
          end
        End

      End Solver

    End presto Region Problem
  End presto Procedure calculations
  begin feti equation solver feti
  end
End Sierra Axis_Symmetric_Graded

