# SM/SD Handoff "Guitar String"
# =============================
# Sierra/SM input
#
# SAND2022-4009 TR

begin sierra string

  begin function ramp
    type is piecewise linear
    begin values
      0.0     0.0
      1.0     1.0
    end
  end

  define point center with coordinates 25 -1.1 0
  define direction zdir with vector 0 0 1
  define axis rot_axis with point center direction zdir

  begin material aluminum
    density         = 2.59e-2
    begin parameters for model elastic
      youngs modulus = 7.8e+7
      poissons ratio = 0.0
    end
  end

  begin finite element model mesh1
    Database Name = bar.g
    Database Type = exodusII

    begin parameters for block block_1 block_3 block_4
      material = aluminum 
      model = elastic
    end
  end finite element model mesh1

  begin adagio procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio
          time increment = 0.05
        end
      end
      termination time = 1.0
    end time control

    begin adagio region adagio
      use finite element model mesh1

      ### output description ###
      begin Results Output output_adagio
        Database Name = bar_preload.e
        Database Type = exodusII
        At Step 0, Increment = 1
        nodal Variables = displacement
        nodal variables = coordinates
        nodal variables = reaction
        element variables = stress
        element variables = log_strain
        component separator character = none
      end results output output_adagio

      ### definition of BCs ###
      begin fixed displacement
        surface = surface_1
        components = XYZ
      end
      begin fixed displacement
        node set = nodelist_1000
        components = z
      end

      begin prescribed displacement
        block = block_4
        radial axis = rot_axis
        function = ramp
        scale factor = 0.0
      end
      begin prescribed displacement
        block = block_4
        cylindrical axis = rot_axis
        function = ramp
        scale factor = -3.14
      end

      begin contact definition
        skin all blocks = on
        begin hybrid model tied_slide
          initially close = tied
          initially far = frictionless
        end
        begin interaction 
          surfaces = block_1 block_3
          friction model = tied_slide
          constraint formulation = node_face
        end        
        begin debug
          write salinas mpcs to sal_mpc.txt at time 0.99
        end

      end



      begin solver
        begin cg
          target relative residual = 1.0e-3
          target residual = 1.0e-1
          acceptable residual = 1.0e+10
          reference = Belytschko
          begin full tangent preconditioner
            tangent diagonal scale = 1.0e-6
          end
          maximum iterations =20
        end
        begin control contact
          target relative residual = 1.0e-2
          target residual = 1.0
        end
      end

    end 
  end 
end 

