#
# LOAD RATE SCALE FACTOR = {load_rate_scale = 1.0}
#
begin sierra tension_specimen
    begin material ss304_sm
        density = 7900

        begin parameters for model j2_plasticity
            youngs modulus = 200.0E9
            poissons ratio = 0.27

            yield_stress = 276024675
            hardening model = decoupled_flow_stress
            isotropic hardening model = power_law
         
            hardening constant = 1300757250
            hardening exponent = 0.62625

            yield rate multiplier     = power_law_breakdown
            hardening rate multiplier = power_law_breakdown

            hardening rate coefficient = 4
            hardening rate exponent    = 0.6

            yield rate coefficient     = 4
            yield rate exponent        = 0.6

            yield temperature multiplier = johnson_cook
            yield melting temperature    = 2750
            yield reference temperature  = 296.15 
            yield temperature exponent   = 0.7

            hardening temperature multiplier = johnson_cook
            hardening melting temperature    = 2000
            hardening reference temperature  = 296.15
            hardening temperature exponent   = 0.7

            thermal softening model = adiabatic
            temp control case = material_controlled
            beta_tq = 0.99
            specific heat = {(3672.0/7900.0)*1000.0}
        end parameters for model j2_plasticity
    end material ss304_sm

    begin function displace
        type is analytic
        evaluate expression = "{0.001524*load_rate_scale}*x"
    end function displace

    define direction x with vector 1.0 0.0 0.0
    define direction y with vector 0.0 1.0 0.0
    define direction z with vector 0.0 0.0 1.0

    begin finite element model SMModel
        database name = ./tension_specimen_qtr.g

        begin parameters for block block_1 block_2 block_3
            material = ss304_sm
            model    = j2_plasticity
        end
    end

    begin adagio procedure adagio_proc
        begin time control
            begin time stepping block step_1
                start time = 0.0
                begin parameters for adagio region adagio_region
                    time increment = {0.1/load_rate_scale}
                end
            end 
            termination time = {8.0/load_rate_scale}
        end

        begin adagio region adagio_region
            use finite element model SMModel

            begin initial temperature
                include all blocks
                magnitude = 296.15
            end

            begin results output 
                database name = output.e
                at time 0, increment = {0.1/load_rate_scale}
     
                nodal variables = displacement
                nodal variables = temperature
                element variables = eqps
                element variables = von_mises
                element variables = damage
                element variables = plastic_work_heat_rate
                element variables = temperature
                global variables  = load
                global variables  = gauge_disp
            end results output daOutput

            begin user output 
                include all blocks
                compute global appDisp as function displace
            end user output

            begin user output
                nodeset = nodelist_3
                compute global negHalfLoad as SUM of NODAL reaction(2)
                compute global load from expression "-2*negHalfLoad"
            end user output

            begin user output
                nodeset = nodelist_11
                compute global gauge_disp as AVERAGE of NODAL displacement(2)
            end user output

            begin fixed displacement
                node set  = nodelist_3
                direction = y
            end fixed displacement

            begin fixed displacement
                node set  = nodelist_4
                direction = x
            end fixed displacement

            begin fixed displacement
                node set  = nodelist_7
                direction = z
            end fixed displacement

            begin prescribed displacement
                node set    = nodelist_5
                direction    = y
                function     = displace
                scale factor = 1.0
            end prescribed displacement

            begin adaptive time stepping
                cutback factor           = 0.5
                maximum failure cutbacks = 5
            end adaptive time stepping

            begin solver
                begin cg
                    target relative residual        = 1.0e-9
                    target residual                 = 1.0e-8
                    reference                       = external
                    maximum iterations              = 1000
                    minimum iterations              = 0
                    preconditioner                  = tangent
                    preconditioner iteration update = 250
                end cg

                begin loadstep predictor
                    type = scale_factor
                    scale factor = 0.0
                end

            end solver
        end #region
    end #procedure
end #sierra
