begin sierra paperclip
  begin definition for function crush
    type is piecewise linear
    begin values
      0.   0.
      1.   1.05
    end values
  end

  begin definition for function crush_eccentricity
    type is piecewise linear
    begin values
      0.   0.
      0.1   0.1
      1.0   0.1
    end values
  end

  begin property specification for material generic_metal
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin finite element model can
    Database name = cylinder.g

    begin parameters for block block_1 
      material = generic_metal
      model = elastic_plastic
      section = can_shell
    end
  end

  begin shell section can_shell
    drilling stiffness factor = 1.0e-3
    thickness = 0.0625
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            #time increment = 0.025
            time increment = 0.01  # Optimization: use a smaller step to avoid failed solves
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model can

      begin fixed displacement
        surface = bottom
        components = x y z
      end fixed displacement

      begin fixed rotation
        surface = bottom
        components = x y z
      end

      begin prescribed displacement
        surface = top
        function = crush
        component = z
        scale factor = -1
      end
      begin prescribed displacement
        surface = top
        function = crush_eccentricity
        component = x
        scale factor = 0.0
      end
      begin fixed displacement
        surface = top
        component = y
      end
      begin fixed rotation
        surface = top
        component = x y z
      end

      begin user output
        sideset = bottom
        compute global bottom_react as sum of nodal reaction
        compute global bottom_disp as function crush
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        element variables = eqps
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
        global bottom_react
        global bottom_disp
      end
    
      begin solver
        begin cg
            target relative residual = 1.0e-3
            #maximum iterations = 100
            maximum iterations = 20 # Optimization: minimize wasted solve iterations
            begin full tangent preconditioner
                small number of iterations = 15  # Optimization: re-use preconditioner if possible.
            end
        end
      end
    
      # Add a basic adaptive time stepping block to 
      # increase robustness of the implicit solve.
      # This will continually halve the timestep until
      # we achieve a successful solve, and then restore 
      # the original attempted time step.
      begin adaptive time stepping
        cutback factor = 0.5
        maximum failure cutbacks = 10
      end

    end # region
  end # procedure
end # sierra
