begin sierra plate_blast_training
  ############### Function Definitions ########################
  begin definition for function CONSTANT_ONE
    type is constant
    begin values
      1.0
    end values
  end definition for function CONSTANT_ONE

  begin definition for function RAMP_LOAD
    type = piecewise linear
    begin values
      0 0
      0.0025 50
      0.005 50
    end values
  end definition for function RAMP_LOAD

  ############### Material Definitions ########################
  begin material material_100
    density=0.000259
    begin parameters for model elastic
      youngs modulus=1e+07
      poissons ratio=0.33
    end parameters for model elastic
    Begin parameters for model elastic_plastic
      beta = 1.0
      hardening modulus = 28695
      poissons ratio = 0.33
      yield stress = 45.0e3
      youngs modulus = 10.0e6
    End parameters for model elastic_plastic
  end material material_100

  ############### Finite Element Model Definition #############
  Begin shell section SHELL_13
    thickness mesh variable = thickness
    offset mesh variable = offset
    integration rule = trapezoid
  End shell section SHELL_13

  Begin finite element model fe_model
    Database Name = plate_material_library.g
    Database Type = exodusII

    Begin parameters for block block_13
      section = SHELL_13
      material material_100
      solid mechanics use model elastic_plastic
    End parameters for block block_13
  End finite element model fe_model

  begin presto procedure presto
    ################ Time Stepping Parameters ###################
    begin time control
      begin time stepping block period_1
        start time = 0.0
        begin parameters for presto region presto
          step interval = 10
        end parameters for presto region presto
      end time stepping block period_1
      termination time = 1.0e-2
    end time control

    begin presto region presto
      ########### Pull in Previously Defined Model##############
      use finite element model fe_model

      ############## Request Output ############################
      begin results output exo_out
        database name = plate.e
        database type = exodusII
        at time 0.0, increment = 1.0e-3
        nodal variables = displacement as disp
        nodal variables = rotational_displacement as rdisp
        nodal variables = velocity as vel
        nodal variables = rotational_velocity as rvel
        nodal variables = acceleration as acc
        nodal variables = rotational_acceleration as racc
        nodal variables = reaction as rf
        nodal variables = rotational_reaction as rrf
        element variables = unrotated_stress
        element variables = von_mises as vonm
        element variables = strain
        element variables = effective_strain
        element variables = timestep as eltstep
        global variables = timestep as tstep
        global variables = kinetic_energy as ke
        global variables = internal_energy as ie
        global variables = external_energy as ee
      end results output exo_out

      begin history output hist_out
        database name = plate_history.e
        database type = exodusII
        at step 0, interval  = 1
        variable = global timestep as tstep
        variable = global kinetic_energy as ke
        variable = global internal_energy as ie
        variable = global external_energy as ee
      end history output hist_out

      ################ Kinematic Boundary Conditions ##########
      begin fixed displacement
        node set = nodelist_1 nodelist_2 nodelist_3 nodelist_4
        component = x y z
      end
      begin fixed rotation
        node set = nodelist_1 nodelist_2 nodelist_3 nodelist_4
        component = x y z
      end

      ############### Force Boundary Conditions ################
      begin pressure
       surface = surface_1002
       function = CONSTANT_ONE
       scale factor = 50.000000
      end

    end presto region presto
  end presto procedure presto
end sierra plate_blast_training
