begin sierra
    begin material generic
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 1
            poissons ratio = 0.0
        end
    end

    begin finite element model two_bricks
        database name = two_dof_bricks.g
        begin parameters for block block_1
            material = generic
            model = elastic
        end
        begin parameters for block block_2
            material = generic
            model = elastic
        end
    end

    begin adagio procedure proc1
        begin time control
            begin time stepping block tb1
                start time = 0.0
                begin parameters for adagio region region1
                    time increment = 1.0
                end
            end

            termination time = 1.0
        end

        begin adagio region region1
            use finite element model two_bricks

            begin distributed force
                surface = top
                function = sierra_constant_function_one
                component = x
                scale factor = -0.1
            end

            begin fixed displacement
                surface = bottom
                component = x y z
            end

            begin solver
                begin cg
                    # Part 1: Tight residual, print often
                    target relative residual = 1.0e-12
                    iteration print = 1

                    # Part 2: Looser residual, print less often
                    #target relative residual = 1.0e-6
                    #iteration print = 100
                end
            end
    
            # Manually compute the external force reference
            begin user output
                surface = top
                compute global externalReference as l2norm of nodal force_external(x)
                compute at every step
            end

            # Use solution verification to show that the external reference is equal to 
            # an expected value.
            begin solution verification
                completion file = verifErr
                verify global externalReference = 0.05 plus or minus 0.001
            end

            begin results output
                database name = output.e
                at step 0, increment = 1
                nodal displacement
                nodal force_external
            end

        end #region
    end #procedure
end #sierra
