begin sierra M10_bolt_preload
 begin material mild_steel
   density = 7896.0
   begin parameters for model elastic_plastic
     youngs modulus = 2.1000E+11
     poissons ratio = 0.29
     yield stress = 3.5000E+8
     hardening modulus = 338.3E+6
     beta = 1.00000
   end
  end 

  begin material bolt_material
    density = 7896.0
    begin parameters for model elastic_plastic
      youngs modulus = 2.1000E+11
      poissons ratio = 0.29
      yield stress = 1170.0E+6
      hardening modulus = 1.44e9
      beta = 1.00000
    end parameters for model elastic_plastic
  end material bolt_material

  begin finite element model FE_model
    database name = M10_boltx2_scaled.g

    begin parameters for block bolt_thread bolt_head bolt_shank_1 bolt_shank_2
      material = bolt_material
      model = elastic_plastic
    end

    begin parameters for block top_plate bottom_plate
      material = mild_steel
      model = elastic_plastic
    end
  end finite element model FE_model


  begin adagio procedure Apst_Procedure
    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio
          number of time steps = 5
        end parameters for adagio region adagio
      end time stepping block p1

      termination time = 2.0e-4
    end time control

    begin adagio region adagio
      use finite element model FE_model

      begin fixed displacement
        node set = nodelist_1 
        components = X Y Z
      end fixed displacement

      begin preload
        preload bolt bolt_shank_1 to target internal force = 30000.0
        preload bolt bolt_shank_2 to target internal force = 30000.0
      end preload

      begin contact definition
        skin all blocks = on

        begin interaction defaults
          general contact = on
          self contact = off
        end interaction defaults
      
        begin interaction tied_bolt
          surfaces = bottom_plate bolt_thread
          friction model = tied
        end interaction tied_bolt
      end contact definition

      begin results output output_adagio
        Database Name = output.e
        at step 0, increment = 1 
        nodal variables = displacement, velocity
        nodal variables = contact_status
        element variables = von_mises
        element variables = eqps
      end

      begin solver
        begin cg
            target relative residual = 0.005
            begin full tangent preconditioner
                small number of iterations = 10
            end
        end cg

        begin control contact
            target relative residual = 0.05
        end
      end solver 

    end #region
  end #procedure
end #sierra
 

 
