begin sierra bending
  begin function forge
    type = piecewise linear
    begin values
      0  0   # begin state
      5  6   # die down
      10 -6  # die up
      15 -6  # hold
      20 0   # die down
      25 6   # die down
      30 -6  # die up
      35 -6  # hold
      40 0   # die down
      45 6   # die down
      50 -6  # die up
      55 -6  # hold
      60 0   # die down
      65 6   # die down
      70 -6  # die up
    end
  end

  begin function move_ingot_y
    type = piecewise linear
    begin values
      0    0
      6    0
      10   6 # raise for inward movement
      15   6 # hold for inward movement
      20   0 # return to original height
      25   0 # hold for forging
      30   6 # raise for inward movement
      35   6 # hold for inward movement
      40   0 # return to original height
      45   0 # hold for forging
      50   6 # raise for inward movement
      55   6 # hold for inward movement
      60   0 # return to original height
      65   0 # hold for forging
    end
  end

  begin function move_ingot_z
    type = piecewise linear
    begin values
      0    0
      5    0
      10   0
      15   -12
      30   -12
      35   -24
      50   -24
      55   -36
      70   -36
    end
  end

  begin definition for function bend_x
    type = analytic
    expression variable: t = global time
    evaluate expression = "5*cos({PI/2}*t) - 5"
  end

  begin definition for function bend_z
    type = analytic
    expression variable: t = global time
    evaluate expression = "5*sin({PI/2}*t)"
  end

  begin definition for function load_ramp
    type is piecewise linear
    begin values
      0.   0.
      1.   1
    end values
  end

  begin property specification for material hot_steel
    density = 7.e-4
    begin parameters for model elastic_plastic
      youngs modulus = 3.0e6   # psi
      poissons ratio = 0.27
      yield stress = 2900      # psi
      hardening modulus = 100  # not based on data
    end
  end

  begin property specification for material cold_steel
    density = 7.e-4
    begin parameters for model elastic
      youngs modulus = 29e6
      poissons ratio = 0.27
    end
  end

  begin finite element model fem_model_1
    database name = open_die_forging.g
    #database name = open_die_forging_r1.g

    begin parameters for block block_1 block_2
      material = cold_steel
      model = elastic
    end

    begin parameters for block ingot
      material = hot_steel
      model = elastic_plastic
    end
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            time increment = 0.5
        end
      end
      termination time = 70.0
    end

    begin adagio region adagio_region
      use finite element model fem_model_1

      # Bottom die: fixed in place
      begin fixed displacement
        surface = bottom_die_bottom
        components = x y z
      end fixed displacement

      # Top die: moves up and down
      begin prescribed displacement
        surface = top_die_top
        component = y
        function = forge
        scale factor = -1
      end
      begin fixed displacement
        surface = top_die_top
        component = x z
      end

      # Ingot: hold at end
      begin fixed displacement
        surface = ingot_negz
        component = x
      end
      begin prescribed displacement
        surface = ingot_negz
        component = y 
        function = move_ingot_y
      end
      begin prescribed displacement
        surface = ingot_negz
        component = z 
        function = move_ingot_z
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
      end
      begin user output
        block = ingot
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        nodal variables = von_mises, eqps
        element variables = eqps
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
            general contact = on
            self contact = off
        end
      end
    
      begin adaptive time stepping
      end

      begin solver
        begin cg
            target relative residual = 1.0e-3
            maximum iterations = 70
            iteration print = 10
            begin full tangent preconditioner
                minimum smoothing iterations = 50
                small number of iterations = 5
            end
        end
        begin control contact
        end
      end
  
    end # region
  end # procedure
end # sierra
