begin sierra btshell_cylinder

  begin function function_radius_over_time
    type is piecewise linear
    begin values
      0.000  2.5
      0.005  2.5
      0.010  2.5
    end values
  end function function_radius_over_time

  begin function function_2
    type is piecewise linear
    begin values
      0.000  0.0
      0.0025 0.3
      0.005  0.3
    end values
  end function function_2

  begin material linear_elastic
    density         = 2.61e-4
    begin parameters for model elastic_plastic
      youngs modulus  = 1.e9
      poissons ratio  = 0.25
      HARDENING MODULUS = 0.0
      YIELD STRESS = 36000.0
      BETA = 1.0
    end parameters for model elastic_plastic
  end material linear_elastic

  begin shell section bt_section
    thickness = 2
    formulation = bt_shell
  end

  begin finite element model mesh1
    Database Name = cylinder_shell.g
    Database Type = exodusII

    begin parameters for block block_1
      section = bt_section
      material linear_elastic
      model = elastic_plastic
      hourglass stiffness = 0.05
    end parameters for block block_1

  end finite element model mesh1

  begin presto procedure Presto_Procedure

    begin time control
      begin time stepping block p1
        start time =  0.0

        begin parameters for presto region presto
          time step scale factor = 1.0
        end parameters for presto region presto

      end time stepping block p1

      termination time = 0.0003
    end time control

    begin presto region presto
      use finite element model mesh1

      begin XFEM xfem
        include all blocks
        add disc = 0.0 -1.0 6.0 0.0 1.0 1.2 function_radius_over_time
        mechanics growth start time = 0.0
        mechanics growth method = mechanics failure
        failure surface evolution = planar
        criterion is element value of max_principal_stress(1) > 2.5e4
        angle change = stress eigenvector
      end

      begin prescribed displacement
        node set = nodelist_2001
        component = y
        function = function_2
        scale factor = 40.0
      end prescribed displacement

      begin prescribed displacement
        node set = nodelist_2002
        component = y
        function = function_2
        scale factor = -40.0
      end prescribed displacement

      ### output description ###
      begin Results Output output_presto
        Database Name = cylinder_shell.e
        Database Type = exodusII
        At time 0.0 increment = 0.000001
        nodal Variables = displacement
        element Variables = memb_stress as mstress
        element Variables = top_stress as topstress
        element Variables = xfem_partial_element_flag
        element Variables = xfem_element_fail_flag
        element Variables = xfem_physical_node_flag
        element Variables = xfem_edge_cut_flag
        element variables = max_principal_stress as my_max_prin
        element Variables = VON_MISES as VonMises
        global Variables = timestep as timestep
        global variables = external_energy
        global variables = internal_energy
        global variables = kinetic_energy
        global variables = momentum
        global variables = facesum
      end results output output_presto

      begin user output
        block = block_1_contact_surface
        compute global faceSum as sum of element skinFaceArea
      end

    end presto region presto
  end presto procedure Presto_Procedure

end sierra btshell_cylinder

