begin sierra paperclip
  begin definition for function load_ramp
    type is piecewise linear
    begin values
      0.   0.
      1.   1
    end values
  end

  begin property specification for material steel
    density = 7.5e-4
    begin parameters for model elastic
      youngs modulus = 28.0e6
      poissons ratio = 0.27
    end
  end

  begin finite element model paperclip
    Database name = paperclip_in.g
    Database type = exodusII
    begin parameters for block block_1 
      material = steel
      model = elastic
    end
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            time increment = 0.1
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model paperclip

      begin fixed displacement
        surface = inside_clip
        components = x y z
      end fixed displacement

      begin distributed force
        surface = outside_end
        function = load_ramp
        scale factor = 1. # [1 lb]
        component = x 
      end

      begin results output results_output
        database name = paperclip.e
        database type = exodusII
        at time 0, increment = 0.1

        nodal variables = displacement as displ
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
        global residual
      end

      begin user output
        compute global residual as l2norm of nodal residual
      end

      begin solver
        begin cg
            iteration plot = 10  # add command to enable visualization of solver 
            target relative residual = 1.0e-3
            maximum iterations = 1000
            line search secant 1.0e-3
            begin full tangent preconditioner
                iteration update = 20
                small number of iterations = 20
            end
        end
      end
  
    end # region
  end # procedure
end # sierra
