Begin Sierra Bullet

#### Title: Bullet collision with concrete block

#### Aprepro variables, which will be used in the user output section of the input file
# Ey: {Ey = 1.999479615E+11}  # Youngs Modulus
# nu: {nu = 0.33333}          # Poissons Ratio
# G: {G = 78.0E+9}            # Shear Modulus
# mu: {mu = 0.3}              # friction coefficient

###############################################################################

#### Define the point for the origin and unit vectors for each axis in both the positive
#### and negative directions.  An axis is also defined using the point 'origin' and the
#### positive x direction, which will be used to define the axis about which the bullet.
#### will rotate
Define point origin with coordinates 0.0 0.0 0.0
Define Direction posX With Vector 1.0 0.0 0.0
Define Axis Xaxis with Point origin Direction posX

###############################################################################

#### Define Functions

#### The function 'Translation' governs the translation of the bullet, and the function 'rotation'
#### governs its rotation
  Begin Function Translation
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Displacement
    Begin Values
      0.00 0.00
      0.10 0.00
      0.20 0.50
    End Values
  End Function Translation

  Begin Function Rotation
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Velocity
    Begin Values
      0.00 0.10
      0.20 0.10
    End Values
  End Function Rotation

#### The contact radius will be the radius of the cylinder and half sphere representing the bullet
#### This could be hard coded, but the following function allows the user to change his geometries
#### without having to re-change the hard coded radius each time they do so
  Begin function radius_of_bullet
    type = analytic
    expression variable: r = nodal model_coordinates(y)
    evaluate expression = "r"
  End function radius_of_bullet

  Begin function node_torque
    type = analytic
    expression variable: y = nodal coordinates(y)
    expression variable: z = nodal coordinates(z)
    expression variable: Fy = nodal force_contact(y)
    expression variable: Fz = nodal force_contact(z)
    evaluate expression = "(Fz*y) - (Fy*z)"
    #evaluate expression = "(Fy*z) - (Fz*y)"
  End function node_torque

###############################################################################

#### Define Material Properties

#### Steel
  Begin material Steel
    density = 10000
    Begin Parameters for Model Elastic_Plastic
      Youngs Modulus = 3.5E+11
      Poissons Ratio = 0.33333
      Yield Stress = 4.5E+8
      Hardening Modulus = 4.5E+8
    end Parameters For Model Elastic_Plastic
  end material Steel

#### Mat2
  Begin material Mat2
    density = 2000.00
    Begin Parameters for Model Elastic_Plastic
      Youngs Modulus = 1.7E+8
      Poissons Ratio = 0.15
      Yield Stress = 2.0E6
      Hardening Modulus = 5.0E5
    end Parameters For Model Elastic_Plastic
  end material Mat2

###############################################################################

#### Define Finite Element Model

  Begin Finite Element Model block_spin
    Database Name = Bullet.g
    Database Type = ExodusII


#### Define Blocks

    Begin Parameters For Block block_1
      Material Steel
      model = Elastic_Plastic
    End Parameters For Block block_1

    Begin Parameters For Block block_2
      Material Mat2
      model = Elastic_Plastic
    End Parameters For Block block_2

  End Finite Element Model block_spin

###############################################################################

  Begin Presto Procedure calculations

#### Define Time and Time Step

    Begin Time Control
      Termination Time = 1.0E-3
      Begin Time Stepping Block Timestep1
        Start Time = 0.0
        Begin Parameters For Presto Region Problem
          Step Interval = 100
        End Parameters For Presto Region Problem
      End Time Stepping Block Timestep1
    End Time Control

###############################################################################

    Begin Presto Region Problem
      Use Finite Element Model block_spin

      Begin Results Output block_spin_output
        Database Name = bullet.e
        database Type = ExodusII
        At Time 0.0 Increment = 5.0E-5
        Nodal Variables = Acceleration As Accel
        Nodal variables = Velocity As Vel
        Nodal Variables = Displacement As Displ
        Nodal Variables = Force_External As Force
        Nodal Variables = Force_Contact As Fc
        Nodal Variables = Reaction As React
        Nodal Variables = Torque as Torque_Node
        Element Variables = Stress As Stress
        Element Variables = Log_Strain As logstra
        Element Variables = Von_Mises As VonMises
        Element Variables = Effective_Log_Strain As ELS
        Global Variables = Ty_top
        Global Variables = T
        Global Variables = P
        Global Variables = Rc
        Global Variables = Rb
      End Results Output block_spin_output

###############################################################################

#### Contact Definition

    Begin Contact Definition collide
      Search = dash
      skin all blocks = ON

      Begin Constant Friction Model friction
        Friction Coefficient = 0.3
      End Constant Friction Model friction

      Begin Interaction Defaults
        general contact = ON
        friction model = friction
      End Interaction Defaults

    End Contact Definition collide

###############################################################################

      Begin Initial Velocity
        Block = block_1
        Component = X
        Magnitude = 400
      End Initial Velocity

      Begin Initial Velocity
        Block = block_1
        Cylindrical Axis = Xaxis
        Angular Velocity = 1000
      End Initial Velocity

#### Fixes sides of concrete block so only deformation occurs
      Begin Fixed Displacement
        Surface = sideset_3
        Components = X Y Z
      End Fixed Displacement

###############################################################################

      Begin User Output
        node set = nodeset_2
        compute nodal radius_of_bullet as function radius_of_bullet
        compute global Rb as max of nodal radius_of_bullet
      End User Output

      Begin User Output
        node set = nodeset_1
        compute global P as sum of nodal Force_Contact(x)
        compute global Reac from expression "P/1000"
        compute nodal torque as function node_torque
        compute global Ty_top as sum of nodal torque
        compute global Rc from expression "3^(1/3)\#
                  *(((-1+{nu}^2)*P*(Rb)/{Ey}+0.0001)/(abs((-1+{nu}^2)*P*(Rb)/{Ey}+0.0001)))\#
                  *(abs((-1+{nu}^2)*P*(Rb)/{Ey}))^(1/3)/(2^(2/3))"
        # T is a non-dimensional value of the torque
        compute global T from expression "abs(Ty_top/({mu}*P*Rc+0.0001))"
      End User Output

      Begin history output torque
        database name = bullet.h
        database type = ExodusII
        At Time 0.0 increment = 0.01
        Variable = global Rb
        Variable = global Ty_top
        Variable = global T
        Variable = global P
        Variable = global Rc
      End history output torque

      Begin Heartbeat Output torque
        Stream Name = bullet.csv
        Format = SpyHis
        Start Time = 0.0
        At Time 0 Increment = 0.001
        Termination Time = 0.05
        Global T as Torque
        Global Rc as Contact_Radius
        Global Reac as Reaction_Force
      End Heartbeat Output torque

###############################################################################

    End Presto Region Problem
  End Presto Procedure calculations
End Sierra Bullet

###############################################################################





