begin Sierra 

  # Metric units are used.
  # - displacement: meters
  # - mass: kilograms
  # - time: seconds
  # - force: kg*m/s^2
  # - temperature: Kelvin


  begin function Disp
    type is piecewise linear
    ordinate is disp
    abscissa is time
    begin values
      0.0       0.0
      0.1       -0.00005
      0.2       -0.0001
      0.3       -0.00015
      0.4       -0.0002
      0.5       -0.00025
      0.6       -0.0003
      0.7       -0.00035
      0.8       -0.0004
      0.9       -0.00045
      1.0       -0.0005         # Absolute length of initial overlap is 0.0005 
      1.1       -0.0005
      1.2       -0.0005
      1.3       -0.0005         # Start of second time step is 1.3 (where contact is turned on)
    end values
  end function Disp


  begin function Disp2
    type is piecewise linear
    ordinate is disp
    abscissa is time
    begin values
      0.0       0.0
      0.1       0.00005
      0.2       0.0001
      0.3       0.00015
      0.4       0.0002
      0.5       0.00025
      0.6       0.0003
      0.7       0.00035
      0.8       0.0004
      0.9       0.00045
      1.0       0.0005        # Absolute length of initial overlap is 0.0005 
      1.1       0.0005
      1.2       0.0005
      1.3       0.0005        # Start of second time step is 1.3 (where contact is turned on) 
    end values
  end function Disp2

  ### --------------------------- ###
  ###   Materials Specification   ###
  ### --------------------------- ###

  begin material steel_bolt
    density          = 7.89e+03
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_bolt

  begin material steel_block
    density          = 7.89e+03
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_block

  ### --------------------------------------- ###
  ###   Input Mesh and Material Description   ###
  ### --------------------------------------- ###

  begin finite element model preDisp
    database name = preDisp_final.g
    database type = exodusII

    begin parameters for block block_1
      material steel_block
      model = elastic
    end parameters for block block_1

    begin parameters for block block_2
      material steel_bolt
      model = elastic
    end parameters for block block_2

  end finite element model preDisp

  ### ---------------------- ###
  ###   Linear Solver        ###
  ### ---------------------- ###

  begin gdsw equation solver gdsw
    residual norm tolerance = 5e-2
  end
  begin feti equation solver feti
    residual norm tolerance = 5e-2
  end

  ### ---------------- ###
  ###   Begin Adagio   ###
  ### ---------------- ###

  begin adagio procedure aProcedure

    ### ---------------- ###
    ###   Time Control   ###
    ### ---------------- ###

    begin time control

      begin time stepping block time1
        start time = 0.0
        begin parameters for adagio region aRegion
          number of time steps = 1
        end parameters for adagio region aRegion
      end time stepping block time1

      begin time stepping block time2
        start time = 1.3
        begin parameters for adagio region aRegion
          number of time steps = 1
        end parameters for adagio region aRegion
      end time stepping block time2

      termination time = 2.0

    end time control

    ### ----------------- ###
    ###   Adagio Region   ###
    ### ----------------- ###

    begin adagio region aRegion
      use finite element model preDisp


      ### ----------------------- ###
      ###   Boundary Conditions   ###
      ### ----------------------- ###


      # --------------------- #
      #     Bolt Preload      #
      # --------------------- #

      begin prescribed displacement
        node set = nodelist_2
        function = Disp
        active periods = time1
        component = Y
      end

      begin prescribed displacement
        node set = nodelist_1
        function = Disp2
        active periods = time1
        component = Y
      end

      # --------------------- #
      #        Loading        #
      # --------------------- #

      begin fixed displacement
        node set = nodelist_3
        component = Z
      end

      begin fixed displacement
        node set = nodelist_4
        component = X Y 
      end

      begin fixed displacement
        node set = nodelist_5
        component = X Y 
      end


      # -------------------- #
      #   Contact Surfaces   #
      # -------------------- #

      begin contact definition
        search = dash

        contact surface surf_101 contains surface_101
        contact surface surf_102 contains surface_102
        contact surface surf_201 contains surface_201
        contact surface surf_202 contains surface_202

        begin constant friction model fric
          friction coefficient = 0.5
        end

        begin inactive friction model inactive
        end

        begin time variant model tv
          model = inactive during periods time1
          model = fric during periods time2
        end

        begin interaction
          side A               = surf_102
          side B                = surf_101
          normal tolerance     = 1.0e-5
          capture tolerance    = 1.0e-6
          friction model       = fric
        end interaction

        begin interaction
          side A               = surf_202
          side B                = surf_201
          normal tolerance     = 1.0e-5
          capture tolerance    = 1.0e-6
          friction model       = tv
        end interaction

      end contact definition

      ### -------------------- ###
      ###   Output Variables   ###
      ### -------------------- ###

      begin results output aOut
        database name = preDisp_final.e
        database type = exodusII
        at step 0 increment = 1
        nodal variables = displacement as displ
        nodal variables = contact_status as celement
        nodal variables = contact_normal_traction_magnitude as cfnor
        nodal variables = contact_tangential_traction_magnitude as cftan
        nodal variables = contact_area as carea
        nodal variables = contact_normal_direction as cdirnor
        nodal variables = contact_tangential_direction as cdirtan
        element variables = stress as stress
        global variables = total_iter as itotal
        global variables  = timestep as timestep
      end

      begin solver

        begin loadstep predictor
          type = scale_factor
          scale factor = 0.0 0.0
        end

        level 1 predictor = none

        begin control contact
          target relative residual        = 1.0e-3
          maximum iterations              = 80
        end

        begin cg
          target     relative residual    = 1.0e-4
          maximum iterations              = 100
          acceptable residual             = 1.0e+10

          begin full tangent preconditioner
            tangent diagonal scale          = 1.0e-6
            linear solver                   = feti
            conditioning                    = no_check
            small number of iterations      = 10
          end 
        end
      end

    end adagio region aRegion
  end adagio procedure aProcedure

end Sierra 
