begin sierra ex13
  begin definition for function disp_ramp
    type is piecewise linear
    begin values
      0.   0.
      1.   0.5
    end values
  end

  begin property specification for material generic
    density = 1e-5
    begin parameters for model elastic
      youngs modulus = 10.0e4
      poissons ratio = 0.27
    end
  end

  begin finite element model can
    Database name = {mesh}

    begin parameters for block block_1 
      material = generic
      model = elastic
      section = sd
    end
  end

  begin solid section sd
    formulation = selective_deviatoric
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            time increment = 0.2
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model can

      begin fixed displacement
        surface = fixed_ss
        components = x y z
      end fixed displacement

      begin prescribed displacement
        surface = load_ss
        function = disp_ramp
        component = x
        scale factor = -1
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        element variables = element_shape
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
      end
    
      begin solver
        begin cg
            target relative residual = 1.0e-3
            preconditioner = tangent
        end
      end
  
    end # region
  end # procedure
end # sierra
