begin sierra bolt_preload

  #
  #  To be used with artificial strain BC
  #
  begin function bolt_preload
    type is analytic
    expression variable: v = element applied_strain
    evaluate expression = "v"
  end

  begin material linear_elastic
    density         = 5.0
    begin parameters for model elastic
      poissons ratio  = 0.34
      youngs modulus  = 7.427E11
    end parameters for model elastic
  end material linear_elastic

  begin finite element model mesh1
    Database Name = bolt_load_test.g
    Database Type = exodusII

    begin parameters for block
      include all blocks
      material = linear_elastic
      model = elastic
    end

  end finite element model mesh1

  begin presto procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for presto region presto
          time step scale factor = 1.0
        end
      end time stepping block p1
      termination time = 1.0e-3
    end time control

    begin presto region presto
      use finite element model mesh1
      ### output description ###
      begin Results Output output_presto
        Database Name = bolt_preload_sub.e
        Database Type = exodusII
        #At time 0.0, interval = 1.0e-4
        At time 0.0, interval = 1.0e-5
        nodal Variables = displacement 
        nodal Variables = force_contact 
        element variables = applied_strain
        global variables = bolt_force_200, bolt_force_300, bolt_force_400
      end results output output_presto

      #
      #  Output the force and strain results from the preload solver
      #  for checking.
      #
      begin history output
        Database Name = bolt_preload_sub.h
        Database Type = exodusII
        at time 0.0, interval = 1.0e-6
        variable = global bolt_force_200
        variable = global applied_strain_200
        variable = global bolt_force_300
        variable = global applied_strain_300
        variable = global bolt_force_400
        variable = global applied_strain_400
      end

      begin node based time step parameters
      end

      begin mass scaling
        include all blocks
        target time step = 4.0e-7
      end


      #
      #  Hold bottom of fixture
      #
      begin fixed displacement
        surface = surface_100
        components = XYZ
      end
    
      #
      #  Bolt to fixture contacts
      #
      begin contact definition
        contact surface bolt2_tied contains surface_210
        contact surface bolt4_tied contains surface_410
        skin all blocks = on
        begin constant friction model med_fric
          friction coefficient = 0.3
        end
        begin interaction defaults
          general contact = on
          friction model = med_fric
        end
        begin interaction 
          side B = bolt2_tied bolt4_tied
          side A = block_100
          friction model = tied
        end
        initial overlap removal = on
      end
      #
      #  Damping coefficent to aid the dynamic relaxation quasistatic solver
      #
      begin viscous damping
        include all blocks
        velocity damping coefficient = 1.0e-3
      end
      #
      #  State variables for bolt preload solver subroutine, defined once for all subroutines
      #
      begin user variable applied_strain
        type = element real length = 1
        use with restart
      end
      begin user variable bolt_preload_state
        type = element real length = 12
        use with restart
      end
      #
      #  Artificial strain driver, need two of these as bolts have two different orientations.  Alternatively
      #  could put this in one block with a variable artificial strain direction, but likely more trouble than it is 
      #  worth
      #
      begin artificial strain
        block = block_201 block_401
        r function = sierra_constant_function_zero
        s function = sierra_constant_function_zero
        t function = bolt_preload
      end      
      begin artificial strain
        block = block_301
        r function = sierra_constant_function_zero
        s function = bolt_preload
        t function = sierra_constant_function_zero
      end      
      #
      #  Solver blocks for preload.  Internal reaction measures the force in the bolts, iterate
      #  the preload to acheive that force.
      #
      begin user output
        block = block_201
        compute global internal_force_200 as internal reaction in direction 0 0 1
        compute global bolt_force_200 as magnitude of global internal_force_200
        subroutine real parameter:   target_value     = 1.0e+7
        subroutine real parameter:   initial_guess    = -3.06e-4
        subroutine real parameter:   iteration_time   = 5.0e-5
        subroutine string parameter: target_variable  = global bolt_force_200
        subroutine string parameter: working_variable = element applied_strain
        subroutine string parameter: state_variable   = element bolt_preload_state
        element block subroutine = aupst_preload_solver
        compute at every step
        compute global applied_strain_200 as average of element applied_strain
      end

      begin user output
        block = block_301
        compute global internal_force_300 as internal reaction in direction 0 1 0
        compute global bolt_force_300 as magnitude of global internal_force_300
        subroutine real parameter:   target_value     = 4.0e+6
        subroutine real parameter:   initial_guess    = -8.0e-5
        subroutine real parameter:   iteration_time   = 5.0e-5
        subroutine string parameter: target_variable  = global bolt_force_300
        subroutine string parameter: working_variable = element applied_strain
        subroutine string parameter: state_variable   = element bolt_preload_state
        element block subroutine = aupst_preload_solver
        compute at every step
        compute global applied_strain_300 as average of element applied_strain
      end

      begin user output
        block = block_401
        compute global internal_force_400 as internal reaction in direction 0 0 1
        compute global bolt_force_400 as magnitude of global internal_force_400
        subroutine real parameter:   target_value     = 1.3e+7
        subroutine real parameter:   initial_guess    = -2.95e-4
        subroutine real parameter:   iteration_time   = 5.0e-5
        subroutine string parameter: target_variable  = global bolt_force_400
        subroutine string parameter: working_variable = element applied_strain
        subroutine string parameter: state_variable   = element bolt_preload_state
        element block subroutine = aupst_preload_solver
        compute at every step
        compute global applied_strain_400 as average of element applied_strain
      end

      #
      #  Optional:  Verify that the target bolt forces were actually obtained at the end of the run.
      #  This is present mostly to make this a simple verification test rather than a regression test.
      #
      begin solution verification
        skip times = 0.0 to 0.99e-3
        #verify global bolt_force_200 = 1.0e+7
        #verify global bolt_force_300 = 4.0e+6
        #verify global bolt_force_400 = 1.3e+7
        relative tolerance = 0.025
        completion file = v1
      end

    end presto region presto
  end presto procedure Apst_Procedure

end sierra bolt_preload

