begin sierra
    begin material generic
        density = 1.0
        begin parameters for model elastic
            youngs modulus = 1
            poissons ratio = 0.0
        end
    end

    begin finite element model two_bricks
        database name = two_dof_bricks.g
        begin parameters for block block_1
            material = generic
            model = elastic
        end
        begin parameters for block block_2
            material = generic
            model = elastic
        end
    end

    begin adagio procedure proc1
        begin time control
            begin time stepping block tb1
                start time = 0.0
                begin parameters for adagio region region1
                    time increment = 1.0
                end
            end

            termination time = 1.0
        end

        begin adagio region region1
            use finite element model two_bricks

            begin distributed force
                surface = top
                function = sierra_constant_function_one
                component = x
                scale factor = -0.1
            end

            begin fixed displacement
                surface = bottom
                component = x y z
            end

            begin solver
            end

            begin results output
                database name = output.e
                at step 0, increment = 1
                nodal displacement
            end

        end #region
    end #procedure
end #sierra
