begin sierra bending
  begin definition for function bend_x
    type = analytic
    expression variable: t = global time
    evaluate expression = "5*cos({PI/2}*t) - 5"
  end

  begin definition for function bend_z
    type = analytic
    expression variable: t = global time
    evaluate expression = "5*sin({PI/2}*t)"
  end

  begin definition for function load_ramp
    type is piecewise linear
    begin values
      0.   0.
      1.   1
    end values
  end

  begin property specification for material generic_metal
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin property specification for material stiff
    density = 2.5e-4
    begin parameters for model elastic
      youngs modulus = 50.0e6
      poissons ratio = 0.27
    end
  end

  begin finite element model plate
    database name = plate_with_hole.g
    #database name = plate_with_hole_refined.g

    begin parameters for block block_1
      material = generic_metal
      model = elastic_plastic
    end

    begin parameters for block block_2
      material = stiff
      model = elastic
    end
  end

  begin solid section sd
    formulation = selective_deviatoric
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            number of time steps = 20
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model plate

      begin fixed displacement
        surface = fixed_surf
        components = x y z
      end fixed displacement

      begin initial mesh modification
        block = block_2
        move x -1 y 0 z 0
      end

      begin tied mpc
        tied faces = block_1
        tied nodes = block_2
      end

      begin prescribed displacement
        nodeset = nodeset_1
        component = x
        function = bend_x
      end

      begin prescribed displacement
        nodeset = nodeset_1
        component = z
        function = bend_z
      end

      begin fixed displacement
        surface = bar_top
        component = x y z
      end

      begin user output
        include all blocks
        extrapolate element variable von_mises to nodal variable von_mises
      end
      begin user output
        block = block_1
        extrapolate element variable eqps to nodal variable eqps
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        nodal variables = von_mises, eqps
        element variables = eqps
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
      end
    
      begin adaptive time stepping
      end

      begin solver
        #begin cg
        #    target relative residual = 1.0e-3
        #    maximum iterations = 300
        #    iteration print = 50
        #end

        # The default CG solve above doesn't converge,
        # so let's try to help it with a better preconditioner
        #begin cg
        #    target relative residual = 1.0e-3
        #    maximum iterations = 100
        #    begin full tangent preconditioner
        #    end
        #end

        # The full tangent preconditioner by itself still didn't
        # converge, so let's try a hybrid option using two different
        # preconditioner types.
        begin cg
            target relative residual = 1.0e-3
            maximum iterations = {200 + 25}
            iteration print = 50
            begin full tangent preconditioner
                minimum smoothing iterations = 200
            end
        end

      end
  
    end # region
  end # procedure
end # sierra
