begin Sierra

  # Metric units are used.
  # - displacement: meters
  # - mass: kilograms
  # - time: seconds
  # - force: kg*m/s^2
  # - temperature: Kelvin

  begin function force_strain ## iterate on this version ## pretty much there with preload 5.0667e5 
    type is piecewise linear
    ordinate is force 
    abscissa is engineering_strain 
    begin values
      -0.05        -7.25e5     
      -0.025       -4.25e5
      0.0          0.0
      0.025        4.25e5
      0.05         7.25e5 
    end values
  end

  begin rigid body TOP_FLANGE
    include nodes in nodelist_101 
  end rigid body TOP_FLANGE

  begin rigid body BOTTOM_FLANGE
    include nodes in nodelist_102 
  end rigid body BOTTOM_FLANGE

  begin spring section spring_1
    force strain function = force_strain
    default stiffness =5.0265e8
    preload = 5.0667e5 #DEFAULT
    mass per unit length = 0.0
  end


  ### --------------------------- ###
  ###   Materials Specification   ###
  ### --------------------------- ###

  begin material steel_bolt
    density          = 7.89e+03
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_bolt

  begin material steel_block
    density          = 7.89e+03
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_block

  ### --------------------------------------- ###
  ###   Input Mesh and Material Description   ###
  ### --------------------------------------- ###

  begin finite element model mesh1
    Database Name = spring_final.g
    Database Type = exodusII

    begin parameters for block block_1
      material steel_block
      model = elastic
    end parameters for block block_1

    begin parameters for block block_2
      material steel_bolt
      model = elastic
    end parameters for block block_2

    begin parameters for block block_3
      section = spring_1
    end parameters for block block_3

  end finite element model mesh1

  ### ---------------------- ###
  ###   Linear Solver        ###
  ### ---------------------- ###

  begin gdsw equation solver gdsw
  end
 
  begin feti equation solver feti
    corner algorithm       = 7
    preconditioning method = lumped
    param-int "maximum_super_nodes" value 32
  end

  begin adagio procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio
          number of time steps = 1
        end parameters for adagio region adagio
      end time stepping block p1

      termination time = 1.0

    end time control

    begin adagio region adagio

      use finite element model mesh1

      begin Results Output output_adagio
        Database Name = spring_final.e
        At step 0, Increment = 1
        nodal variables = force_contact as force_contact
        nodal variables = force_external as force_external
        nodal variables = force_internal as force_internal
        nodal variables = displacement as displ
        nodal variables = contact_status as celement
        nodal variables = contact_normal_traction_magnitude as cfnor
        nodal variables = contact_tangential_traction_magnitude as cftan
        nodal variables = contact_slip_increment_current as cdtan
        nodal variables = contact_area as carea
        nodal variables = contact_normal_direction as cdirnor
        nodal variables = contact_tangential_direction as cdirtan
        element variables = stress as stress
        element variables = spring_force as spring_force 
        element variables = spring_engineering_strain as spring_engineering_strain
        global variables  = timestep as timestep
      end

      ### definition of BCs ###

      begin fixed displacement
        node set = nodelist_3
        component = Z
      end

      begin fixed displacement
        node set = nodelist_1
        component = X Y Z
      end

      begin fixed rotation
        #node set = nodelist_101 
        rigid body= BOTTOM_FLANGE
        component = X Y Z
      end

      begin fixed rotation
        #node set = nodelist_102 
        rigid body = TOP_FLANGE
        component = X Y Z
      end


      begin fixed displacement
        node set = nodelist_2
        component = X Y Z
      end

      # -------------------- #
      #   Contact Surfaces   #
      # -------------------- #

      begin contact definition

        contact surface surf_101 contains surface_101
        contact surface surf_102 contains surface_102
        contact surface surf_201 contains surface_201
        contact surface surf_202 contains surface_202

        begin constant friction model fric
          friction coefficient = 0.5
        end

        begin interaction
          side A               = surf_102
          side B                = surf_101
          friction model       = fric
        end interaction

        begin interaction
          side A               = surf_202
          side B                = surf_201
          friction model       = fric
        end interaction

      end contact definition

      begin solver

        begin loadstep predictor
          type = scale_factor
          scale factor = 0.0 0.0
        end

        level 1 predictor = none

        begin control contact
          target relative residual        = 1.0e-3
          target residual                 = 1.0e-8
          maximum iterations              = 60
          minimum iterations              = 10
        end

        begin cg
          reference                       = internal
          target     relative residual    = 1.0e-4
          target residual                 = 1.0e-9
          maximum iterations              = 1000
          minimum step length             = 0.001
          maximum step length             = 100.0
          begin full tangent preconditioner
            tangent diagonal scale          = 1.0e-6
            linear solver                   = feti
            conditioning                    = no_check
            small number of iterations      = 100
          end 
        end
      end

    end adagio region adagio
  end adagio procedure Apst_Procedure

end Sierra 
