begin sierra cohesive_dcb

  begin function ramp
    type is piecewise linear
    begin values
      0.0   0.0
      1.0  1.0
    end values
  end function ramp

  begin function spring_restore
    type is piecewise linear
    ordinate is load
    abscissa is time
    begin values
      0.0   0.0
      0.05  1.0
    end values
  end function spring_restore

  define direction y with vector 0.0 1.0 0.0

  begin material test
    density         = 7.3240e-4
    begin parameters for model elastic
      youngs modulus  = 30.e5
      poissons ratio  = 0.3
    end parameters for model elastic
    begin parameters for model tvergaard_hutchinson
      lambda_1 = 0.5
      lambda_2 = 0.5
      normal length scale = 0.1
      tangential length scale = 0.1
      peak traction = 50.0e3
      penetration stiffness multiplier = 1.0
      use elastic unloading = no
    end parameters for model tvergaard_hutchinson
  end material test

  begin cohesive section cohesive_sect
  end cohesive section cohesive_sect


  begin finite element model mesh1
    Database Name = curved_plates.g
    Database Type = exodusII
    begin parameters for block block_1 
      material = test
      model = elastic
    end

  end finite element model mesh1

  begin presto procedure Apst_Procedure
    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for presto region presto
        time step scale factor =  1.0
        end parameters for presto region presto
      end time stepping block p1        
      termination time = 2e-4
    end time control

    begin presto region presto

      use finite element model mesh1

      ### output description ###
      begin Results Output output_presto
        Database Name = curved_plates.e
        Database Type = exodusII
        At Time 0.0, Increment = 1.0E-5
        nodal Variables = force_external as f_ext
        nodal Variables = force_internal as f_int
        nodal Variables = velocity as vel
        nodal Variables = acceleration as acc
        nodal Variables = displacement as displ
        nodal variables = force_contact
        global Variables = tot_fracture_area
        element Variables = stress as str
        element Variables = von_mises as vm
        element Variables = cse_traction
        element Variables = cse_separation
        element variables = death_status
        global variables = external_energy as ExternalEnergy
        global variables = internal_energy as InternalEnergy
        global variables = kinetic_energy as KineticEnergy
        global variables = momentum as Momentum
        global variables = timestep as TIMESTEP
      end results output output_presto

      ### definition of BCs ###

      begin XFEM xfem1
        include all blocks
        initial cut with sideset surface_3
        initial surface cohesive = true
        cohesive section = cohesive_sect
        cohesive material = test
        cohesive model = tvergaard_hutchinson
        volume fraction lower bound = 1.0e-6
      end

      begin fixed displacement
        surface = surface_1
        components = x y z 
      end fixed displacement

      begin prescribed displacement      
        surface = surface_2
        direction = y
        function = ramp
        scale factor = -1000
      end prescribed displacement          

    end presto region presto
  end presto procedure Apst_Procedure

end sierra cohesive_dcb
