begin Sierra

  # Metric units are used.
  # - displacement: meters
  # - mass: kilograms
  # - time: seconds
  # - force: kg*m/s^2
  # - temperature: Kelvin

  #The bolt is cooled to -10 Kelvin in one step.
  begin function TEMPERATURE
    type is piecewise linear
    ordinate is temperature
    abscissa is time
    begin values
      0.0       0.0
      1.0     -10.0
      10.0    -10.0
    end values
  end function TEMPERATURE

  begin function THERMAL_STRAIN_X
    type is piecewise linear
    ordinate is strain
    abscissa is temperature
    begin values
      0.0        0.0
      1.0        0.0
      1000       0.0
    end values
  end function THERMAL_STRAIN_X

  #Thermal strain is applied to the bolt only in the longitudinal direction of
  #the bolt.
  begin function THERMAL_STRAIN_Y
    type is piecewise linear
    ordinate is strain
    abscissa is temperature
    begin values
      0.0      0.0
      -10       -5.0E-02
      -1000.0   -5.0E-02
    end values
  end function THERMAL_STRAIN_Y

  begin function THERMAL_STRAIN_Z
    type is piecewise linear
    ordinate is strain
    abscissa is temperature
    begin values
      0.0        0.0
      1.0        0.0
      1000       0.0
    end values
  end function THERMAL_STRAIN_Z

  ### --------------------------- ###
  ###   Materials Specification   ###
  ### --------------------------- ###

  begin material steel_bolt
    density          = 7.89e+03
    thermal engineering strain X function = THERMAL_STRAIN_X
    thermal engineering strain Y function = THERMAL_STRAIN_Y
    thermal engineering strain Z function = THERMAL_STRAIN_Z
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_bolt

  begin material steel_block
    density          = 7.89e+03
    begin parameters for model elastic
      youngs modulus = 200.e+09
      poissons ratio = 0.29
    end parameters for model elastic
  end material steel_block

  ### --------------------------------------- ###
  ###   Input Mesh and Material Description   ###
  ### --------------------------------------- ###

  begin finite element model thermalPreLoad
    database name = thermal_final.g
    database type = exodusII

    begin parameters for block block_1
      material steel_block
      model = elastic
    end parameters for block block_1

    begin parameters for block block_2
      material steel_bolt
      model = elastic
    end parameters for block block_2

  end finite element model thermalPreLoad

  ### ---------------------- ###
  ###   Linear Solver        ###
  ### ---------------------- ###

  begin gdsw equation solver gdsw
    residual norm tolerance = 1e-2
  end
  begin feti equation solver feti
    residual norm tolerance = 1e-2
  end

### ---------------- ###
###   Begin Adagio   ###
### ---------------- ###

  begin adagio procedure aProcedure

    ### ---------------- ###
    ###   Time Control   ###
    ### ---------------- ###

    begin time control

      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio
          number of time steps = 1
        end parameters for adagio region adagio
      end time stepping block p1

      termination time = 1.0

    end time control

    begin adagio region adagio

      use finite element model thermalPreLoad


      # --------------------- #
      #     Bolt Preload      #
      # --------------------- #

      #The temperature changed is applied to the entire bolt.
      begin prescribed temperature
        block = block_2
        function = TEMPERATURE
      end prescribed temperature

      # --------------------- #
      #        Loading        #
      # --------------------- #

      begin fixed displacement
        node set = nodelist_3
        component = Z
      end

      begin fixed displacement
        node set = nodelist_4
        component = X Y 
      end

      begin fixed displacement
        node set = nodelist_5
        component = X Y 
      end

      # -------------------- #
      #   Contact Surfaces   #
      # -------------------- #

      begin contact definition

        contact surface surf_101 contains surface_101
        contact surface surf_102 contains surface_102
        contact surface surf_201 contains surface_201
        contact surface surf_202 contains surface_202

        begin constant friction model fric
          friction coefficient = 0.5
        end

        begin interaction
          side A               = surf_102
          side B                = surf_101
          friction model       = fric
        end interaction

        begin interaction
          side A               = surf_202
          side B                = surf_201
          friction model       = fric
        end interaction

      end contact definition

      ### -------------------- ###
      ###   Output Variables   ###
      ### -------------------- ###

      begin results output aOut
        database name = thermal_final.e
        database type = exodusII
        at step 0 increment = 1
        nodal variables = displacement as displ
        nodal variables = contact_status as celement
        nodal variables = contact_normal_traction_magnitude as cfnor
        nodal variables = contact_tangential_traction_magnitude as cftan
        nodal variables = contact_area as carea
        nodal variables = contact_normal_direction as cdirnor
        nodal variables = contact_tangential_direction as cdirtan
        element variables = stress as stress
        element Variables = temperature as temp
        global variables = total_iter as itotal
        global variables  = timestep as timestep
      end

      begin solver

        begin loadstep predictor
          type = scale_factor
          scale factor = 1.0 0.0
        end

        level 1 predictor = none

        begin control contact
          target relative residual        = 1.0e-3
          maximum iterations              = 100
        end

        begin cg
          target     relative residual    = 1.0e-4
          maximum iterations              = 100

          begin full tangent preconditioner
            linear solver                   = feti
            conditioning                    = no_check
            small number of iterations      = 15
          end 
        end
      end

    end adagio region adagio
  end adagio procedure aProcedure

end Sierra 
