begin sierra Contact_Planes1

  begin function load
    type is piecewise linear
    begin values
      0.0 0.0
      8.0e-4 1.0
    end values
  end function load

  begin material linear_elastic_steel
    density         = 7.34e-4
    begin parameters for model elastic_plastic
      youngs modulus  = 30e6
      poissons ratio  = 0.3
      yield stress = 34.7e4
      hardening modulus = 34.7e4
      beta = 1.0
    end parameters for model elastic_plastic
  end material linear_elastic_steel

  begin finite element model mesh1
    Database Name = analytic_multiple.g
    Database Type = exodusII

    begin parameters for block block_1
      material = linear_elastic_steel
      model = elastic_plastic
    end parameters for block block_1
  end finite element model mesh1

  begin presto procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for presto region presto
          time step scale factor =  1.0
          step interval = 10
        end parameters for presto region presto
      end time stepping block p1
      termination time = 8.0e-4
    end time control

    begin presto region presto
      use finite element model mesh1

      ### output description ###
      begin Results Output output_presto
        Database Name = analytic_multiple.e
        Database Type = exodusII
        At Time 0.0, Increment = 1.0e-4
        nodal Variables = force_external as f_ext
        nodal Variables = force_internal as f_int
        nodal Variables = velocity as vel
        nodal Variables = acceleration as accl
        nodal Variables = displacement as displ
        nodal variables = contact_status
        nodal variables = force_contact as cforce
        nodal variables = mass
        element Variables = stress as stress
        global Variables = timestep as timestep
        global variables = external_energy as ExternalEnergy
        global variables = internal_energy as InternalEnergy
        global variables = kinetic_energy as KineticEnergy
        global variables = momentum as Momentum
      end results output output_presto

      ### definition of initial conditions ###
      begin analytic object obj1
        type = PLANE
        normal direction = 0 1 0
        origin = 0.0 0.0 0.0
        scale factor = 3.0
      end

      begin fixed displacement
        surface = obj1
        component = x y z
      end

      begin analytic object obj2
        type = PLANE
        normal direction = 1 -1 0
        origin = -4.0 0.0 0.0
        scale factor = 1.0
      end

      begin prescribed displacement
        surface = obj2
        component = y
        scale factor = -3.0
        function = load
      end
      begin fixed displacement
        surface = obj2
        component = xz
      end

      ### contact definition ###
      begin contact definition basic1
        contact surface surf_1 contains obj1
        contact surface surf_2 contains obj2
        contact surface block_1 contains block_1
        search = dash
        begin interaction defaults
          general contact = on
          self contact = on
        end

        begin interaction
          side A = surf_1
          side B = block_1
        end

        begin interaction
          side A = surf_2 
          side B = block_1
        end
      end contact definition basic1

    end presto region presto
  end presto procedure Apst_Procedure

end sierra Contact_Planes1

