function two_dof_system_implicit_direct()
    % Define our two-dof system
    k1 = 1;
    k2 = 1;
    F0 = -0.1;
    
    % Define the linear system of equations
    K = [k1, -k1; -k1, k1 + k2];
    F = [F0; 0.0];

    % Implicitly SOLVE our system.
    u = K\F;
    
    % Print the output
    disp(' ');
    disp('*******************')
    disp('SOLUTION:');
    disp(['  displacement: u1 = ', num2str(u(1))]);
    disp(['  displacement: u2 = ', num2str(u(2))]);
    disp('*******************')
end
