begin sierra paperclip
  begin definition for function crush
    type is piecewise linear
    begin values
      0.   0.
      1.   1.05
    end values
  end

  begin definition for function crush_eccentricity
    type is piecewise linear
    begin values
      0.   0.
      0.1   0.1
      1.0   0.1
    end values
  end

  begin property specification for material generic_metal
    density = 2.5e-4
    begin parameters for model elastic_plastic
      youngs modulus = 10.0e6
      poissons ratio = 0.27
      yield stress = 35e3
      hardening modulus = 10e3
    end
  end

  begin property specification for material heavy_metal
    density = 10
    begin parameters for model elastic
      youngs modulus = 30.0e6
      poissons ratio = 0.27
    end
  end

  begin finite element model can
    Database name = cylinder_stack.g

    begin parameters for block block_1 block_2 block_3
      material = generic_metal
      model = elastic_plastic
      section = can_shell
    end

    begin parameters for block block_4 block_5
      material = heavy_metal
      model = elastic
    end
  end

  begin finite element model can_solid_elements
    Database name = cylinder_stack_solid.g

    begin parameters for block block_1 block_2 block_3
      material = generic_metal
      model = elastic_plastic
    end

    begin parameters for block block_4 block_5
      material = heavy_metal
      model = elastic
    end
  end

  begin shell section can_shell
    drilling stiffness factor = 1.0e-3
    thickness = 0.0625
  end

  begin adagio procedure adagio_proc
    begin time control
      begin time stepping block step_1
        start time = 0.
        begin parameters for adagio region adagio_region
            time increment = 0.005
        end
      end

      begin time stepping block step_2
        start time = 0.22
        begin parameters for adagio region adagio_region
            time increment = 0.0005
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model can_solid_elements

      begin implicit dynamics
        contact timestep = off
      end

      begin fixed displacement
        surface = plate_bottom
        components = x y z
      end fixed displacement

      #begin fixed rotation
      #  block = block_1 block_2
      #  components = x y z
      #end

      begin gravity
        include all blocks
        gravitational constant = -386.4
        component = z
      end

      begin user output
        sideset = bottom
        compute global bottom_react as sum of nodal reaction
        compute global bottom_disp as function crush
      end

      begin contact definition
        skin all blocks = on
        begin interaction defaults
          general contact = on
          self contact = on
          #al penalty = 0.01
          friction model = rough
        end

        begin dash options
          search length scaling = 0.5
        end

        begin constant friction model rough
          friction coefficient = 0.3
        end

        begin surface options
          shell contact lofting factor = 0.0
        end

        begin remove initial overlap
        end

        #begin debug
        #    visualize contact facets = on
        #end
      end

      begin results output results_output
        database name = output.e
        database type = exodusII
        at step 0, increment = 1

        nodal variables = displacement
        nodal variables = rotational_displacement
        nodal variables = velocity
        nodal variables = rotational_velocity
        nodal variables = force_contact
        nodal variables = contact_status
        element variables = eqps
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
        global bottom_react
        global bottom_disp
      end
    
      begin solver
        begin loadstep predictor
          type = scale_factor
          scale factor = 1 0 during step_1
          scale factor = 0 during step_2
        end
        begin cg
            target residual = 1.0 during step_1
            target relative residual = 1.0e-4 during step_2
            target relative residual = 0.01 during step_1
            acceptable relative residual = 1000
            maximum iterations = 100 during step_1
            maximum iterations = 50 during step_2
            iteration print = 20
            begin full tangent preconditioner
            #  iteration print = 5
              small number of iterations = 10
              minimum smoothing iterations = 40 during step_1
              tangent diagonal scale = 1.0e-4
              tangent diagonal shift = 1.0e-4
            end
        end

        begin control contact 
           target residual = 1.0 during step_1
           target relative residual = 0.1 during step_1
           target relative residual = 1.0e-3 during step_2
        end
      end

      begin adaptive time stepping
        maximum failure cutbacks = 5
        cutback factor = 0.5
      end
  
    end # region
  end # procedure
end # sierra
