Begin Sierra Frame
  #### Title Frame-Indifference Verification Test
  ###############################################################################

  define direction z with vector 0.0 0.0 1

  DEFINE POINT origin WITH COORDINATES  0.0 0.0 0.0
  DEFINE POINT along_z WITH COORDINATES 0.0 0.0 1.0
  DEFINE POINT along_x WITH COORDINATES 1.0 0.0 0.0
  DEFINE AXIS z_axis WITH POINT origin DIRECTION z

#### Define Functions
  Begin Function Rotate
    Type = Analytic
    Evaluate Expression = "1.57079632679"
  End Function Rotate

  Begin Function art_strain_X
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Strain
    Begin Values
      0.00  0.00 
      1.00  1E-3
    End Values
  End Function art_strain_X

  Begin Function art_strain_Y
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Strain
    Begin Values
      0.00  0.00
      1.00  0.00
    End Values
  End Function art_strain_Y

  Begin Function art_strain_Z
    Type = Piecewise Linear
    Abscissa = Time
    Ordinate = Strain
    Begin Values
      0.00  0.00
      1.00  0.00
    End Values
  End Function art_strain_Z

###############################################################################
#### Define Material Properties

#### Steel
  Begin material Steel
    density = 7871.966988
    Begin Parameters for Model Elastic_Plastic
      Youngs Modulus = 1.999479615E+11
      Poissons Ratio = 0.33333
      Yield Stress = 275790291.7
      Hardening Modulus = 275790291.7
    end Parameters For Model Elastic_Plastic
    Artificial Engineering Strain X Function = art_strain_X
    Artificial Engineering Strain Y Function = art_strain_Y
    Artificial Engineering Strain Z Function = art_strain_Z
  end material Steel
###############################################################################

#### Define Finite Element Model
  Begin Finite Element Model block_rotate
    Database Name = Frame_Ind.g
    Database Type = ExodusII

#### Define Blocks
    Begin Parameters For Block block_1
      Material Steel
      Model = Elastic_Plastic
    End Parameters For Block block_1
  End Finite Element Model block_rotate

###############################################################################
  Begin Adagio Procedure calculations

    #### Define Time and Time Step
    Begin Time Control
      Begin Time Stepping Block Timestep1
        Start Time = 0.0
        Begin Parameters For Adagio Region Problem
          #Step Interval = 100
          Number of time steps = 50
        End Parameters For Adagio Region Problem
      End Time Stepping Block Timestep1
      Begin Time Stepping Block Timestep2
        Start Time = 1.0
        Begin Parameters For Adagio Region Problem
          #Step Interval = 100
          Number of time steps = 50
        End Parameters For Adagio Region Problem
      End Time Stepping Block Timestep2
      Termination Time = 2.0
    End Time Control

###############################################################################
    Begin Adagio Region Problem
      Use Finite Element Model block_rotate

###############################################################################

#### BCs
      Begin Fixed Displacement
        node set = nodeset_6 nodeset_4
        Components = Y X Z 
        Active Periods = Timestep1 Timestep2
      End Fixed Displacement 

      Begin Prescribed Velocity
        Surface = sideset_1
        Cylindrical Axis = z_axis
        Function = Rotate
        Scale Factor = 1
        Active Periods = Timestep2
      End Prescribed Velocity

###############################################################################
      Begin User Output
        compute global max_abs_stress_xx as max absolute value of element stress(xx) 
        compute global max_abs_stress_yy as max absolute value of element stress(yy) 
        compute global max_abs_stress_zz as max absolute value of element stress(zz) 
        compute global max_abs_stress_xy as max absolute value of element stress(xy) 

        compute global stressxxnorm from expression "max_abs_stress_xx/3E8"
        compute global stressyynorm from expression "max_abs_stress_yy/3E8"
        compute global stresszznorm from expression "max_abs_stress_zz/3E8"
        compute global stressxynorm from expression "max_abs_stress_xy/3E8"
      End User Output
      
      Begin Heartbeat Output normalized
        Stream Name = FrameInd.csv
        Format = SpyHis
        Start Time = 0.0
        At Time 0 Increment = 0.005
        Termination Time = 2.0
        Global stressxxnorm as stressxxnorm 
        Global stressyynorm as stressyynorm
        Global stresszznorm as stresszznorm
        Global stressxynorm as stressxynorm
      End Heartbeat Output normalized

      Begin Results Output block_spin_output
        Database Name = Frame_Ind.e
        Database Type = ExodusII
        At Step 0 Increment = 2
        Nodal Variables = Acceleration As Accel
        Nodal variables = Velocity As Vel
        Nodal Variables = Displacement As Displ
        Nodal Variables = Force_External As Force
        Element Variables = Stress As Stress
        Element Variables = Log_Strain As logstra
        Element Variables = Von_Mises As VonMises
        Element Variables = Effective_Log_Strain As ELS
        Global Variables = stressxxnorm as stressxxnorm
        Global Variables = stressyynorm as stressyynorm
        Global Variables = stresszznorm as stresszznorm
        Global Variables = stressxynorm as stressxynorm

        #Global Variables = max_abs_stress_xx as max_stress_xx
        #Global Variables = max_abs_stress_yy as max_stress_yy
        #Global Variables = max_abs_stress_zz as max_stress_zz
        #Global Variables = max_abs_stress_xy as max_stress_xy

      End Results Output block_spin_output

###############################################################################
      begin solver
        begin cg
          target relative residual  = 1.0E-5
          maximum iterations  = 1000
          acceptable residual = 1.0e+10
          begin full tangent preconditioner
            linear solver = feti
          end
        end
      end

###############################################################################

    End Adagio Region Problem
  End Adagio Procedure calculations
  begin feti equation solver feti
  end
End Sierra Frame


