begin sierra BarrelRoll

  define direction y with vector 0 1 0

  begin rigid body roller
    include nodes in nodeset_1
  end rigid body roller

#Define materials
#alluminum

  BEGIN material MAT1
    DENSITY = 2720
    BEGIN PARAMETERS FOR MODEL ELASTIC_PLASTIC
      YOUNGS MODULUS = 68.9e6
      POISSONS RATIO =0.33 
      HARDENING MODULUS = 0.0
      YIELD STRESS = 276e6
      BETA = 1.0
    END PARAMETERS FOR MODEL ELASTIC_PLASTIC
  END material MAT1

#define FEM model

  begin finite element model ramp
    database name = 40.g
    database type = exodusII
    begin parameters for block block_1 block_2 block_3
      material = MAT1
      model = ELASTIC_PLASTIC
    end parameters for block block_1 block_2 block_3
  end finite element model ramp


  ${termination_time=0.5}
  begin presto procedure precal
    #define problem time parameters
    begin time control
      termination time = {termination_time}
      begin time stepping block timestepping
        start time = 0.0
      end time stepping block timestepping
    end time control

#define problem
    begin presto region local
      use finite element model ramp

#define output
      begin results output putout
        database name = %B.e
        database type = exodusII
        at time 0.0, increment = .1
        nodal variables = displacement
        nodal variables = velocity
        global variables = rotvz_roller as rotational_velocity
        global variables = velx_roller as vx
        global variables = vely_roller as vy
        global variables = displx_roller
        global variables = disply_roller
        nodal variables = contact_status
        global variables = Slip_Ratio
      end results output putout

      begin user output
        node set = nodeset_1
        Compute Global tv from expression "abs(rotVz_roller*0.2)"
        compute global displace from expression "sqrt(displx_roller^2+disply_roller^2)"
        Compute Global V from expression "sqrt(velx_roller^2+vely_roller^2)"
        Compute Global Slip_Ratio from expression "V/tv-1"
      end user output

      Begin Heartbeat Output
        Stream Name = %B.csv
        Format = SpyHis
        Start Time = 0.0
        At Time 0 Increment = 0.04
        Termination Time = {termination_time}
        global timestep as t
        global Slip_Ratio as Slip_Ratio
        global rotvz_roller as rotational_velocity
        global V as V
        global displace as displace
      End Heartbeat Output

#define boundary conditions
      begin fixed displacement
        block = block_2
        components = x z y
      end fixed displacement
      begin gravity
        direction = y
        gravitational constant = -9.81
      end gravity

#define contact
      begin contact definition contact
        skin all blocks = on
        search = dash
        begin interaction defaults
          friction model = sticky
          general contact = on
          self contact = off
        end interaction defaults
        begin constant friction model sticky
          friction coefficient = 0.40
        end constant friction model sticky
      end contact definition contact
    end presto region local
  end presto procedure precal
end sierra BarrelRoll

