##
## Mesh | Loading | Command Line
##--------------------------------
## mesh1 | zero z-displacement | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h1 thickness=t05  plane_constraint=zero_displacement"
## mesh1 | zero pressure       | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h1 thickness=t05  plane_constraint=zero_pressure"
## mesh1 | zero z-traction     | sierra adagio -i plateWithHole.i ....
## ... -D "elem=hex section=ug h_refinement=h1 thickness=t05  plane_constraint=zero_traction"
## mesh1 | zero z-force        | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h1 thickness=t05  plane_constraint=zero_force"
## mesh1 | free z-DOF          | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h1 thickness=t05  plane_constraint=free"
## mesh2 | zero z-displacement | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h2 thickness=t025 plane_constraint=zero_displacement"
## mesh2 | zero pressure       | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h2 thickness=t025 plane_constraint=zero_pressure"
## mesh2 | zero z-traction     | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h2 thickness=t025 plane_constraint=zero_traction"
## mesh2 | zero z-force        | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h2 thickness=t025 plane_constraint=zero_force"
## mesh2 | free z-DOF          | sierra adagio -i plateWithHole.i ...
## ... -D "elem=hex section=ug h_refinement=h2 thickness=t025 plane_constraint=free"
##

begin sierra plateWithHole

  title plate with a hole test

  define direction x with vector 1.0 0.0 0.0
  define direction z with vector 0.0 0.0 1.0

  begin function line
    type is analytic
    evaluate expression = "x"
  end function line

  begin function zero
    type is analytic
    evaluate expression = "0.0"
  end function zero

  begin material steel
    density = 1.0
    begin parameters for model elastic
      youngs modulus = 200.0e9
      poissons ratio = 0.3
    end parameters for model elastic
  end material steel

  {if(section == "ug")}
  begin solid section {section}
  end solid section {section}
  {endif}

  {if(section == "sd")}
  begin solid section {section}
    formulation = selective_deviatoric
    deviatoric parameter = 1.0
  end solid section {section}
  {endif}

  begin finite element model fem
    database name = {elem}.{h_refinement}.{thickness}.g
    begin parameters for block block_1
      material = steel
      model = elastic
      section = {section}
    end parameters for block block_1
  end finite element model fem

  begin adagio procedure agio_procedure

    begin time control
      begin time stepping block p0
        start time = 0.0
        begin parameters for adagio region agio_region
          time increment = 1.0
        end parameters for adagio region agio_region
      end time stepping block p0
      termination time = 1.0
    end time control

    begin adagio region agio_region

      use finite element model fem

      begin fixed displacement left_symmetry_BC
        node set = nodelist_1
        components = x
      end fixed displacement left_symmetry_BC

      begin fixed displacement bottom_symmetry_BC
        node set = nodelist_2
        components = y
      end fixed displacement bottom_symmetry_BC

      begin fixed displacement back_symmetry_BC
        side set = sideset_2
        components = z
      end fixed displacement back_symmetry_BC

      begin traction right_tensile_load
        side set = sideset_3
        direction = x
        function = line
        scale factor = 10000.0
      end traction right_tensile_load

      {if(plane_constraint == "zero_force")}
      begin prescribed force plane_constraint_{plane_constraint}
        side set = sideset_1 
        component = z
        function = zero
      end prescribed force plane_constraint_{plane_constraint}
      {endif}

      {if(plane_constraint == "zero_traction")}
      begin traction plane_constraint_{plane_constraint}
        side set = sideset_1
        direction = z
        function = zero
      end traction plane_constraint_{plane_constraint}
      {endif}

      {if(plane_constraint == "zero_pressure")}
      begin pressure plane_constraint_{plane_constraint}
        side set = sideset_1
        function = zero
      end pressure plane_constraint_{plane_constraint}
      {endif}

      {if(plane_constraint == "zero_displacement")}
      begin prescribed displacement plane_constraint_{plane_constraint}
        side set = sideset_1
        component = z
        function = zero
      end prescribed displacement plane_constraint_{plane_constraint}
      {endif}

      begin results output agio_region_output
        database name = {elem}.{section}.{h_refinement}.{thickness}.{plane_constraint}.e
        at time 1.0 increment = 1.0
        global variables = kinetic_energy
        global variables = internal_energy
        global variables = external_energy
        global variables = stress_zz_max
        global variables = log_strain_zz_max
        nodal variables = displacement
        nodal variables = force_external
        nodal variables = force_internal
        element variables = log_strain
        element variables = stress
        element variables = unrotated_stress
      end results output agio_region_output

      begin user output
        include all blocks
        compute global stress_zz_max     as max absolute value of element stress(zz)
        compute global log_strain_zz_max as max absolute value of element log_strain(zz)
      end user output

      begin solution verification
        {if(plane_constraint == "zero_displacement")}
        verify global log_strain_zz_max <= 1.0e-12
        {else}
        verify global stress_zz_max <= 100.0
        {endif}
        completion file = {elem}.{section}.{h_refinement}.{thickness}.{plane_constraint}.verif
      end solution verification

      begin solver
        begin cg
          reference = external
          target relative residual = 1e-10
          begin full tangent preconditioner
            iteration update = 10
            linear solver = feti
          end full tangent preconditioner
        end cg
      end solver
    end adagio region agio_region
  end adagio procedure agio_procedure
  begin feti equation solver feti
  end
end sierra plateWithHole
