begin sierra wishbone

  #
  #  To be used with distributed force BC
  #
  begin function solved_force
    type is analytic
    expression variable: v = global applied_force
    evaluate expression = "v"
  end

  begin material steelish
    density         = 0.1
    begin parameters for model elastic_plastic
      poissons ratio  = 0.34
      youngs modulus  = 7.427E11
      yield stress = 3.0e+7
      hardening modulus = 1.0e+10
    end parameters for model elastic_plastic
  end

  begin finite element model mesh1
    Database Name = wishbone.g
    Database Type = exodusII

    begin parameters for block
      include all blocks
      material = steelish
      model = elastic_plastic
    end

  end finite element model mesh1

  begin adagio procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for adagio region adagio
          time increment = 1.0e-5
        end
      end time stepping block p1
      termination time = 2.0e-3
    end time control

    begin adagio region adagio
      use finite element model mesh1

      begin Results Output output_adagio
        Database Name = wishbone.e
        Database Type = exodusII
        At time 0.0, interval = 1.0e-4
        nodal Variables = displacement 
        element variables = eqps
      end results output output_adagio

      begin history output
        Database Name = wishbone.h
        Database Type = exodusII
        at time 0.0, interval = 1.0e-6
        variable = global applied_force
        variable = global curDisp
        variable = global force_left 
        variable = global force_right
      end
      #
      #  make plane stress
      #
      begin fixed displacement
        include all blocks
        components = z
      end
      #
      #  Add symmetry planes to make statically determinate
      #
      begin fixed displacement
        node set = nodelist_100
        component = x
      end
      begin fixed displacement
        node set = nodelist_200
        component = y
      end
      #
      #  State variables for preload solver subroutine
      #
      begin user variable applied_force
        type = global real length = 1
        initial value = 0.0
        global operator= max
      end
      begin user variable preload_solver_state
        type = global real length = 12
        global operator= max
      end
      #
      #  Apply a distributed force to the two end holes to mimic load pins, apply force to reach a target deformation
      #
      begin distributed force
        node set = nodelist_1
        function = solved_force
        scale factor = -1.0
        component = x
      end      
      begin distributed force
        node set = nodelist_2
        function = solved_force
        scale factor = 1.0
        component = x
      end
      #
      #  Solver blocks for preload.  Tune applied force to reach a target displacement 
      #
      begin user output
        node set = nodelist_1
        compute global disp_left as average of nodal displacement(x)
        compute global force_left as sum of nodal force_external(x)
        compute at every step
      end
      begin user output
        node set = nodelist_2
        compute global disp_right as average of nodal displacement(x)
        compute global force_right as sum of nodal force_external(x)
        compute at every step
      end

      begin user output
        compute global curDisp from expression "disp_right - disp_left"
        subroutine real parameter:   target_value     = 0.2
        subroutine real parameter:   initial_guess    = 3.0e+6
        subroutine real parameter:   iteration_time   = 2.0e-4
        subroutine string parameter: target_variable  = global curDisp
        subroutine string parameter: working_variable = global applied_force
        subroutine string parameter: state_variable   = global preload_solver_state
        element block subroutine = aupst_preload_solver
        compute at every step
      end
      #
      #  Optional:  Verify that the target bolt forces were actually obtained at the end of the run.
      #  This is present mostly to make this a simple verification test rather than a regression test.
      #
      begin solution verification
        skip times = 0.0 to 1.9e-3
        verify global curDisp = 0.2
        relative tolerance = 0.025
        completion file = v2
      end

    begin solver
      begin cg
        begin full tangent preconditioner
          linear solver = feti
        end
      end
    end

    end adagio region adagio
  end adagio procedure Apst_Procedure
  begin feti equation solver feti
  end
end sierra wishbone
