begin sierra btshell_multiHoles

  begin function function_2
    type is piecewise linear
    begin values
      0.000  0.0
      0.05    0.1
      0.1    0.2
      0.15    0.3
      0.2    0.4
      0.25    0.5
      0.3     0.6
      0.35    0.7
      0.4    0.8
      0.45    0.9
      0.5    1.0
    end values
  end function function_2

  begin material plate_mat
    density         = 0.0078
    begin parameters for model elastic_plastic
      youngs modulus  = 210E3
      poissons ratio  = 0.3
      yield stress = 360
      hardening modulus = 50E3
      beta = 0.75
    end parameters for model elastic_plastic
  end material plate_mat

  begin shell section bt_section
    thickness = 0.8
    formulation = bt_shell
    integration rule = gauss
    number of integration points = 4
  end

  begin cohesive section cohesive_section
    thickness = 1.0
    number of integration points = 4
  end

  begin finite element model mesh1
    Database Name = multiHoles.g
    Database Type = exodusII

    begin parameters for block block_1
      section = bt_section
      material plate_mat
      model = elastic_plastic
      hourglass stiffness = 0.8
      hourglass viscosity = 0.2
    end parameters for block block_1

  end finite element model mesh1

  begin presto procedure Presto_Procedure

    begin time control
      begin time stepping block p1
        start time =  0.0

        begin parameters for presto region presto
          time step scale factor = 0.1
        end parameters for presto region presto

      end time stepping block p1

      termination time = 0.036
    end time control

    begin presto region presto
      use finite element model mesh1

      begin XFEM xfem1
        include all blocks
        generation by nucleation = element-based
        nucleation criterion is element value of max_principal_stress > 1.0E3
        angle change = stress eigenvector
        mechanics growth start time = 0.0
        mechanics growth method = mechanics failure
        failure surface evolution = piecewise linear
        criterion is element value of max_principal_stress > 8.0E2
        crack branching = allowed
        branching criterion is element value of max_principal_stress > 9.5E2
      end

      begin prescribed force
        node set = nodelist_1
        component = y
        function = function_2
        scale factor = -4000
      end prescribed force

      begin prescribed force
        node set = nodelist_2
        component = y
        function = function_2
        scale factor = 4000
      end prescribed force

      ### output description ###
      begin Results Output output_presto
        Database Name = multiHoles.e
        Database Type = exodusII
        At time 0.0 increment = 0.0001
        nodal Variables = displacement
        nodal Variables = rotational_displacement as rot_disp
        element Variables = memb_stress as ms
        element Variables = VON_MISES as VonMises
        element Variables = xfem_partial_element_flag
        element Variables = xfem_element_fail_flag
        element Variables = xfem_physical_node_flag
        element Variables = xfem_edge_cut_flag
        element variables = max_principal_stress as my_max_prin
        global Variables = timestep as timestep
        global variables = external_energy
        global variables = internal_energy
        global variables = kinetic_energy
        global variables = momentum
      end results output output_presto

    end presto region presto
  end presto procedure Presto_Procedure

end sierra btshell_multiHoles

