begin sierra paperclip
  begin definition for function load_ramp
    type is piecewise linear
    begin values
      0.   0.
      1.   1
    end values
  end

  begin definition for function hg_ratio_function
    type = analytic
    expression variable: hged = element hourglass_energy_density
    expression variable: ied = element internal_energy_density
    evaluate expression = "hged/ied"
  end

  begin property specification for material steel
    density = 7.5e-4
    begin parameters for model elastic
      youngs modulus = 28.0e6
      poissons ratio = 0.27
    end
  end

  begin finite element model paperclip
    #database name = paperclip_in.g
    database name = ../eyes/paperclip_with_eyes_in.g
    Database type = exodusII
    begin parameters for block block_1 eyes
      material = steel
      model = elastic
      #section = sd
    end
  end

  begin solid section sd
    formulation = selective_deviatoric
    deviatoric parameter = 0.01
  end

  begin solid section fi
    formulation = fully_integrated
  end

   begin adagio procedure adagio_proc

    begin time control
      begin time stepping block step_1
        start time = 0
        #begin parameters for presto region adagio_region
        #end

        begin parameters for adagio region adagio_region
            time increment = 0.05
        end
      end
      termination time = 1.0
    end

    begin adagio region adagio_region
      use finite element model paperclip

      begin fixed displacement
        surface = inside_clip
        components = x y z
      end fixed displacement

      begin distributed force
        surface = outside_end
        function = load_ramp
        scale factor = 1. # [1 lb]
        component = x 
      end

      begin distributed force
        surface = outside_end
        function = load_ramp
        scale factor = 0.5 # [1 lb]
        component = y 
      end

      begin results output results_output
        database name = paperclip.e
        database type = exodusII
        #at step 0, increment = 1
        at time 0, increment = 0.1

        nodal variables = displacement as displ
        nodal variables = stress
        nodal variables = contact_status, force_contact
        element variables = von_mises
        element variables = hourglass_energy
        element variables = internal_energy
        element variables = hg_ratio
      end

      begin user output
        extrapolate element variable stress to nodal variable stress
        compute element hg_ratio as function hg_ratio_function
      end

      begin solver
        begin cg
            #target relative residual = 1.0e-3
            target relative residual = 1.0e-4
            acceptable relative residual = 1000
            reference = belytschko
            minimum iterations = 1
            maximum iterations = 150
            iteration print = 1

            begin full tangent preconditioner
                minimum smoothing iterations = 5
                small number of iterations = 15
            end
        end

        begin control contact
            target relative residual = 1.0e-3
        end
      end

      begin adaptive time stepping
        maximum failure cutbacks = 5
        cutback factor = 0.5
      end

      begin contact definition 
        skin all blocks = on
        begin interaction defaults
          general contact = on
          self contact = on
        end

        begin interaction
            surfaces = block_1, eyes
            friction model = tied
        end
      end
  
    end # region
  end # procedure
end # sierra

