begin sierra bolt_preload

  #
  #  To be used with artificial strain BC
  #
  begin function bolt_preload
    type is analytic
    expression variable: v = element applied_strain
    evaluate expression = "v"
  end

  begin material linear_elastic
    density         = 5.0
    begin parameters for model elastic
      poissons ratio  = 0.34
      youngs modulus  = 7.427E11
    end parameters for model elastic
  end material linear_elastic

  begin finite element model mesh1
    Database Name = bolt_load_test.g
    Database Type = exodusII

    begin parameters for block
      include all blocks
      material = linear_elastic
      model = elastic
    end

  end finite element model mesh1

  begin presto procedure Apst_Procedure

    begin time control
      begin time stepping block p1
        start time = 0.0
        begin parameters for presto region presto
          time step scale factor = 1.0
        end
      end time stepping block p1
      termination time = 1.0e-3
    end time control

    begin presto region presto
      use finite element model mesh1
      ### output description ###
      begin Results Output output_presto
        Database Name = bolt_preload_automatic.e
        Database Type = exodusII
        At time 0.0, interval = 1.0e-4
        nodal Variables = displacement 
        nodal Variables = force_contact 
        element variables = applied_strain
        global variables = sm_preload_axial_force_block_201
        global variables = sm_preload_axial_force_block_301
        global variables = sm_preload_axial_force_block_401
      end results output output_presto

      #
      #  Output the force and strain results from the preload solver
      #  for checking.
      #
      begin history output
        Database Name = bolt_preload_automatic.h
        Database Type = exodusII
        at time 0.0, interval = 1.0e-6
        variable = global sm_preload_axial_force_block_201
        variable = global sm_preload_axial_force_block_301
        variable = global sm_preload_axial_force_block_401
      end

      begin node based time step parameters
      end

      begin mass scaling
        include all blocks
        target time step = 4.0e-7
      end


      #
      #  Hold bottom of fixture
      #
      begin fixed displacement
        surface = surface_100
        components = XYZ
      end
    
      #
      #  Bolt to fixture contacts
      #
      begin contact definition
        contact surface bolt2_tied contains surface_210
        contact surface bolt4_tied contains surface_410
        skin all blocks = on
        begin constant friction model med_fric
          friction coefficient = 0.3
        end
        begin interaction defaults
          general contact = on
          friction model = med_fric
        end
        begin interaction 
          side B = bolt2_tied bolt4_tied
          side A = block_100
          friction model = tied
        end
        initial overlap removal = on
      end

      #
      #  Damping coefficent to aid the dynamic relaxation quasistatic solver
      #
      begin viscous damping
        include all blocks
        velocity damping coefficient = 1.0e-3
      end

      #
      #  Solver blocks for preload.  Internal reaction measures the force in the bolts, iterate
      #  the preload to acheive that force.
      #
      begin preload
        preload bolt block_201 to target internal force = 1e7 in direction global_z
        preload bolt block_301 to target internal force = 4e6 in direction global_y
        preload bolt block_401 to target internal force = 1.3e7 in direction global_z
        compute internal reaction outputs = on
        iteration time = 5.0e-5
        initial guess = -2.0e-4
      end

      #
      #  Optional:  Verify that the target bolt forces were actually obtained at the end of the run.
      #  This is present mostly to make this a simple verification test rather than a regression test.
      #
      begin solution verification
        skip times = 0.0 to 0.99e-3
        verify global sm_preload_axial_force_block_201 = 1.0e+7
        verify global sm_preload_axial_force_block_301 = 4.0e+6
        verify global sm_preload_axial_force_block_401 = 1.3e+7
        relative tolerance = 0.025
        completion file = v1
      end

    end presto region presto
  end presto procedure Apst_Procedure

end sierra bolt_preload

