#{Ym=64e9}
#{Pr=0.2}
#{E11=64e9}
#{E22=64e9}
#{E33=64e9}
#{NU12=.2}
#{NU13=.2}
#{NU23=.2}

begin Sierra 
  
  begin function ramp1
    type is piecewise linear
    begin values
      0.0 1.0
      1.0e-6 0.75
      2.0e-6 1.0
    end
  end 

  define point pt with coordinates 0.0 0.0 0.0
  define point xx with coordinates 1.0 0.0 0.0
  define point yy with coordinates 0.0 1.0 0.0
  define point zz with coordinates 0.0 0.0 1.0

  begin cylindrical coordinate system cylind
    origin   = 0.0 0.0 0.0
    z point  = 0.0 0.0 1.0
    xz point = 1.0 0.0 0.0
  end

  begin material mat
    density          = .2
  
    begin parameters for model elastic_orthotropic
      youngs modulus = {Ym}
      poissons ratio = {Pr}
      E11 = {E11}
      E22 = {E22}
      E33 = {E33}
      NU12 = {NU12}
      NU13 = {NU13}
      NU23 = {NU23}
      G12 = {E11/(2*(1+NU12))}
      G13 = {E11/(2*(1+NU13))}
      G23 = {E11/(2*(1+NU23))}
      coordinate system = cylind
    end
end

  # section data --------------------------------------------------------
  begin solid section hexes

  end

  # FE model ------------------------------------------------------------
  
  begin finite element model slender_beam
    database name = overlap_removal_strain.g
    database type = exodusII
    
    begin parameters for block block_1
      material mat
      model = elastic_orthotropic
        section = hexes
    end parameters for block block_1


    begin parameters for block block_2
      material mat
      model = elastic_orthotropic
        section = hexes
    end parameters for block block_2

  end finite element model slender_beam

  # procedure data ------------------------------------------------------
  
  begin presto procedure beam_procedure
    
    begin time control
      
      begin time stepping block p1
        start time = 0.0
        begin parameters for presto region beam_region

        end parameters for presto region beam_region
      end time stepping block p1
      begin time stepping block p2
        start time = 1e-6
        begin parameters for presto region beam_region
        end parameters for presto region beam_region
      end time stepping block p2
      
      termination time = 2e-6
      
    end time control
    
    begin presto region beam_region

      use finite element model slender_beam

      # BC data -------------------------------------------------------------
  
      begin artificial strain b1
        include all blocks
        direction field material_direction_1 Function = ramp1
      end

      begin contact definition
        active periods = p2
        skin all blocks  = on
        begin interaction defaults
          general contact = on
        end interaction defaults
      end contact definition

      # BC data -------------------------------------------------------------

  begin results output
    database name = overlap_removal_strain.e
    database type = exodusII
    at time 0.0 increment = 2e-5
    nodal variables = displacement as displ
    nodal variables = velocity as velo
    nodal variables = damage
    nodal variables = removed_overlap
    element variables = stress_degradation
    element variables = max_principal_strain
    element variables = effective_strain
    element variables = effective_log_strain
    element variables = stress as elem_stress
    element variables = max_principal_stress
    element variables = max_principal_stress_direction as mpsdir
    element variables = log_strain
    element variables = temperature as tempE
    element variables = material_direction_1
    element variables = material_direction_2
    element variables = material_direction_3
    global variables = timestep
    global variables = internal_energy
    global variables = kinetic_energy
    global variables = strain_energy
  end
    
    end presto region beam_region
    
  end presto procedure beam_procedure
  
end sierra
